<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Penjualan;
use App\Pembelian;
use App\User;
use App\Pelanggan;
use App\Barang;
use Auth;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {    
        $daterange = explode(' - ', (isset($_GET['daterange']))?$_GET['daterange']:date('Y-m-d H:i',strtotime('-1 Month')).' - '.date('Y-m-d H:i'));
        $s = (isset($_GET['s']))?$_GET['s']:'';
        
        $from = date('Y-m-d',strtotime($daterange[0]));
        $to =    date('Y-m-d',strtotime($daterange[1]));
// dd($to);
        
        $jumlahPembelian = Pembelian::whereBetween('tgl_pembelian',[$from,$to])->count();
        $jumlahPenjualan = Penjualan::whereBetween('tgl_penjualan',[$from,$to])->count();

        $jumlahPembelianHariIni = Pembelian::where('tgl_pembelian',date('Y-m-d'))->count();
        $jumlahPenjualanHariIni = Penjualan::where('tgl_penjualan',date('Y-m-d'))->count();
        
        $transaksiPembelian = 0;
        $transaksiPembelianHariIni = 0;

        $pembelian = Pembelian::all();

        foreach ($pembelian as $data) {
            foreach ($data->detail as $detail) {
                if($detail->harga_barang){
                    $hargaDiskon= $detail->harga_barang->harga_beli - $detail->diskon;
                    $transaksiPembelian += $hargaDiskon * $detail->jumlah;
                    if($data->tgl_pembelian == date('Y-m-d')){
                        $transaksiPembelianHariIni += $hargaDiskon * $detail->jumlah;
                    }
                }
                    
            }
        }



        $transaksiPenjualan = 0;
        $transaksiPenjualanHariIni = 0;

        $penjualan = Penjualan::whereBetween('tgl_penjualan',[$from,$to])->get();
        $ttlItem = 0;
        foreach ($penjualan as $data) {
            foreach ($data->detail as $detail) {
                $hargaDiskon= @$detail->harga_barang->harga_jual - $detail->diskon;
                $transaksiPenjualan += $hargaDiskon * $detail->jumlah + $data->ongkos_kirim;
                if($data->tgl_penjualan == date('Y-m-d')){
                    $transaksiPenjualanHariIni += $hargaDiskon * $detail->jumlah + $data->ongkos_kirim;
                }
                $ttlItem += $detail->jumlah;
            }
        }

        $totalPendapatan = [];
        $date = null;
        $ttl = 0;
        $gttl = 0;
        $pb = Penjualan::whereBetween('tgl_penjualan',[$from,$to])->orderBy('tgl_penjualan','DESC')->get();
        $i = 0;
        foreach ($pb as $d) {
            
            foreach ($d->detail as $detail) {
                $hargaDiskon= @$detail->harga_barang->harga_jual - $detail->diskon;
               
                if($d->tgl_penjualan != $date){
                    $ttl = ($hargaDiskon * $detail->jumlah) - (@$detail->harga_barang->harga_beli * $detail->jumlah);
                    $date = $d->tgl_penjualan;
                } else {
                    $ttl += ($hargaDiskon * $detail->jumlah) - (@$detail->harga_barang->harga_beli * $detail->jumlah);
                }
                $i++;
            }
            if($i < 15){
                $totalPendapatan[] = $ttl;
            }
                

            $gttl += $ttl;
            $ttl = 0;
        }

        $persenBarang = 0;

        $brg = Barang::all();
        $ttlBrg = 0;
        foreach ($brg as $e) {
            $ttlBrg += $e->stok + $e->stok_opname;
        }


        $seluruh = $ttlBrg + $ttlItem;
        $persen = 0;
        if($ttlItem > 0 && $seluruh > 0)
        $persen = ($ttlItem / $seluruh * 100);
        
        $persenBarang = ceil($persen);





        $title = "Dashboard";
        $url = "dashboard";
        $menu = "Home";
        return view('home',compact('title','url','menu','jumlahPembelian','jumlahPenjualan','transaksiPembelian','transaksiPenjualan','jumlahPembelianHariIni','jumlahPenjualanHariIni','transaksiPembelianHariIni','transaksiPenjualanHariIni','totalPendapatan','gttl','persenBarang'));
    }
}
