<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Pelanggan;
use App\BayarPenjualan;
use Auth;
class BayarPenjualanController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $s = (isset($_GET['s']))?$_GET['s']:'';
        $datas = Pelanggan::where('nm_pelanggan','like','%'.$s.'%')->whereHas('penjualan',function($q){
            $q->where('keterangan','Kredit')->orWhere('keterangan', 'Transfer Kredit')->orWhere('keterangan', 'Transfer Credit')->orWhere('keterangan', 'Transfer Credit')->orWhere('keterangan', 'EDC Kredit');
        })->orderBy('created_at','DESC')->paginate(10);
        $datas->appends('s');

        $title = "Pembayaran Piutang";
        $url = "pembayaran_piutang";
        $menu = "Transaksi";
        $no = 1;
       
        return view('bayar_penjualan.index',compact('title','url','menu','no','datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $l = BayarPenjualan::orderBy('no_bayar_penjualan','DESC')->first();
        $kd = "BP00000";
        if($l){
            $kd = $l->no_bayar_penjualan;
        }
        
        $cek = BayarPenjualan::create([
            'no_bayar_penjualan'=>++$kd,
            'kd_pelanggan'=>$request->kd_pelanggan,
            'tgl_bayar_penjualan'=>date("Y-m-d"),
            'uang_bayar'=>$request->uang_bayar,
            'id_user'=>Auth::user()->id

        ]);
        if($cek){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Tambah"
            ]);
            \Helper::add_user_log("Membayar Hutang Penjualan ".$cek->no_bayar_penjualan);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Tambah"
            ]);
            return redirect()->back();
        }

        return redirect('pembayaran_piutang/'.$request->kd_pelanggan);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = Pelanggan::find($id);

        $title = "Pembayaran Piutang";
        $url = "pembayaran_piutang";
        $menu = "Transaksi";
        $no = 1;
       
        return view('bayar_penjualan.detail',compact('title','url','menu','no','data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
