<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Supplier;
use App\BayarPembelian;
use Auth;
class BayarPembelianController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $s = (isset($_GET['s']))?$_GET['s']:'';
        $datas = Supplier::where('nm_supplier','like','%'.$s.'%')->whereHas('pembelian',function($q){
            $q->where('keterangan','Kredit')->orWhere('keterangan','Transfer Kredit')->orWhere('keterangan', 'Transfer Credit')->orWhere('keterangan', 'Transfer Credit')->orWhere('keterangan', 'EDC Kredit')->orWhere('keterangan', 'EDC Credit');
        })->orderBy('created_at','DESC')->paginate(10);
        $datas->appends('s');

        $title = "Pembayaran Hutang";
        $url = "pembayaran_hutang";
        $menu = "Transaksi";
        $no = 1;
       
        return view('bayar_pembelian.index',compact('title','url','menu','no','datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $l = BayarPembelian::orderBy('no_bayar_pembelian','DESC')->first();
        $kd = "BP00000";
        if($l){
            $kd = $l->no_bayar_pembelian;
        }
        
        $cek = BayarPembelian::create([
            'no_bayar_pembelian'=>++$kd,
            'kd_supplier'=>$request->kd_supplier,
            'tgl_bayar_pembelian'=>date("Y-m-d"),
            'uang_bayar'=>$request->uang_bayar,
            'id_user'=>Auth::user()->id

        ]);
        if($cek){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Tambah"
            ]);
            \Helper::add_user_log("Membayar Hutang Pembelian ".$cek->no_bayar_pembelian);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Tambah"
            ]);
            return redirect()->back();
        }

        return redirect('pembayaran_hutang/'.$request->kd_supplier);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = Supplier::find($id);

        $title = "Pembayaran Hutang";
        $url = "pembayaran_hutang";
        $menu = "Transaksi";
        $no = 1;
       
        return view('bayar_pembelian.detail',compact('title','url','menu','no','data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
