<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Barang;
use App\HargaBarang;
use App\Jenis;
use App\Merek;
use App\Satuan;
use App\Exports\BarangsExport;
use App\Imports\BarangsImport;
use Maatwebsite\Excel\Facades\Excel;
use Artisan;
class BarangController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   
        
        if(!\Helper::cek_akses('Barang','View')){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Anda Tidak Memiliki Akses"
            ]);

            return redirect('/');
        }

        $jeniss = Jenis::all();
        $mereks = Merek::all();
        $satuans = Satuan::all();

        $s = (isset($_GET['s']))?$_GET['s']:'';
        $kd_jenis = isset($_GET['kd_jenis'])?$_GET['kd_jenis']:'';
        $kd_merek = isset($_GET['kd_merek'])?$_GET['kd_merek']:'';
        $urutkan = isset($_GET['urutkan'])?$_GET['urutkan']:'new';

       
        $datas = Barang::where(function ($q)use($s)
        {
            $q->where('nm_barang','like','%'.$s.'%')->orWhere('barcode','like','%'.$s.'%');
        })->where('kd_jenis','like','%'.$kd_jenis.'%')->where('kd_merek','like','%'.$kd_merek.'%');

        switch ($urutkan) {
            case 'old':
                $datas = Barang::where(function ($q)use($s)
        {
            $q->where('nm_barang','like','%'.$s.'%')->orWhere('barcode','like','%'.$s.'%');
        })->where('kd_jenis','like','%'.$kd_jenis.'%')->where('kd_merek','like','%'.$kd_merek.'%')->orderBy('created_at','ASC')->paginate(10);
                break;
            case 'asc':
                $datas = Barang::where(function ($q)use($s)
        {
            $q->where('nm_barang','like','%'.$s.'%')->orWhere('barcode','like','%'.$s.'%');
        })->where('kd_jenis','like','%'.$kd_jenis.'%')->where('kd_merek','like','%'.$kd_merek.'%')->orderBy('nm_barang','ASC')->paginate(10);
                break;
            case 'desc':
                $datas = Barang::where(function ($q)use($s)
        {
            $q->where('nm_barang','like','%'.$s.'%')->orWhere('barcode','like','%'.$s.'%');
        })->where('kd_jenis','like','%'.$kd_jenis.'%')->where('kd_merek','like','%'.$kd_merek.'%')->orderBy('nm_barang','DESC')->paginate(10);
                break;
            default:
                $datas = Barang::where(function ($q)use($s)
        {
            $q->where('nm_barang','like','%'.$s.'%')->orWhere('barcode','like','%'.$s.'%');
        })->where('kd_jenis','like','%'.$kd_jenis.'%')->where('kd_merek','like','%'.$kd_merek.'%')->orderBy('created_at','DESC')->paginate(10);
                break;
        }


       
        $datas->appends($_GET);
        

        $title = "Barang";
        $url = "barang";
        $menu = "Master Data";
        $no = 1;
       
        return view('barang.index',compact('title','url','menu','no','datas','mereks','jeniss','satuans'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   

        if(!\Helper::cek_akses('Barang','Add')){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Anda Tidak Memiliki Akses"
            ]);

            return redirect('/');
        }

        $jeniss = Jenis::all();
        $mereks = Merek::all();
        $satuans = Satuan::all();

        $title = "Barang";
        $url = "barang";
        $menu = "Master Data";
        $no = 1;
        $bar = "BAR000001";

        $d = Barang::orderBy('barcode','desc')->first();
        if($d && strpos($d->barcode, 'BAR') !== false){
            $bar = $d->barcode;
        }
       
        return view('barang.create',compact('title','url','menu','no','jeniss','mereks','jeniss','satuans','bar'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        $l = Barang::orderBy('kd_barang','DESC')->first();
        $kd = "B000000";
        if($l){
            $kd = $l->kd_barang;
        }

        $this->validate($request,[
            'nm_barang'=>'required|string',
            'kd_jenis'=>'required|string',
            'kd_merek'=>'required|string',
            'stok'=>'required|numeric',
            'stok_opname'=>'required|numeric',
            'stok_minimal'=>'required|numeric',
            'stok_maksimal'=>'required|numeric'
        ]);
        $gambar_barang = null;
        if($request->hasFile('gambar_barang')){
            $gambar_barang = $request->nm_barang.'.'.request()->gambar_barang->getClientOriginalExtension();
            request()->gambar_barang->move(public_path('images/barang'), $gambar_barang);
        }

        $cek = Barang::create([
            'kd_barang'=>++$kd,
            'nm_barang'=>$request->nm_barang,
            'barcode'=>$request->barcode,
            'kd_jenis'=>$request->kd_jenis,
            'kd_merek'=>$request->kd_merek,
            'stok'=>$request->stok,
            'stok_opname'=>$request->stok_opname,
            'stok_minimal'=>$request->stok_minimal,
            'stok_maksimal'=>$request->stok_maksimal,
            'kd_satuan_stok'=>$request->kd_satuan_stok,
            'gambar_barang'=>$gambar_barang
        ]);

        $sb = $request->kd_satuan_beli;
        $sj = $request->kd_satuan_jual;
        $bi = $request->beli_isi;
        $hb = $request->harga_beli;
        $hj = $request->harga_jual;
        $ds = $request->diskon;
        $jpb = $request->jumlah_persatuan_beli;
        $jpj = $request->jumlah_persatuan_jual;

        $harga = [];
        for ($i=0; $i < count($sj); $i++) { 
            $harga[] = [
                'kd_barang'=>$cek->kd_barang,
                'kd_satuan_beli'=>$sb[$i],
                'jumlah_persatuan_beli'=>$jpb[$i],
                'jumlah_persatuan_jual'=>$jpj[$i],
                'beli_isi'=>$bi[$i],
                'kd_satuan_jual'=>$sj[$i],
                'harga_beli'=>$hb[$i],
                'harga_jual'=>$hj[$i],
                'diskon'=>$ds[$i]
            ];
        }






        if($cek){
            $cek2 = HargaBarang::insert($harga);
            if($cek2){
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-success",
                        "massage" => "Data Berhasil Di Tambah"
                ]);
                \Helper::add_user_log("Menambah Data Barang ".$cek->nm_barang);
            } else {
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-danger",
                        "massage" => "Data Gagal Di Tambah"
                ]);
                Barang::find($cek->kd_barang)->delete();
                return redirect()->back();
            }
            
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Tambah"
            ]);
            return redirect()->back();
        }

        return redirect('barang');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   

        if(!\Helper::cek_akses('Barang','Edit')){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Anda Tidak Memiliki Akses"
            ]);

            return redirect('/');
        }
        $data = Barang::find($id);
        $jeniss = Jenis::all();
        $mereks = Merek::all();
        $satuans = Satuan::all();

        $title = "Barang";
        $url = "barang";
        $menu = "Master Data";
        $no = 1;
       
        return view('barang.edit',compact('title','url','menu','no','data','jeniss','mereks','jeniss','satuans'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {   

        $this->validate($request,[
            'nm_barang'=>'required|string',
            'kd_jenis'=>'required|string',
            'kd_merek'=>'required|string',
            'stok'=>'required|numeric',
            'stok_opname'=>'required|numeric',
            'stok_minimal'=>'required|numeric',
            'stok_maksimal'=>'required|numeric',
        ]);

        $cek = Barang::find($id);
        $gambar_barang = $cek->gambar_barang;
        if($request->hasFile('gambar_barang')){
            $gambar_barang = $request->nm_barang.'.'.request()->gambar_barang->getClientOriginalExtension();
            request()->gambar_barang->move(public_path('images/barang'), $gambar_barang);
        }

        $old_data = $cek;
        $cek->update([
            
            'nm_barang'=>$request->nm_barang,
            'barcode'=>$request->barcode,
            'kd_jenis'=>$request->kd_jenis,
            'kd_merek'=>$request->kd_merek,
            'stok'=>$request->stok,
            'stok_opname'=>$request->stok_opname,
            'stok_minimal'=>$request->stok_minimal,
            'stok_maksimal'=>$request->stok_maksimal,
            'kd_satuan_stok'=>$request->kd_satuan_stok,
            'gambar_barang'=>$gambar_barang

        ]);

        $sb = $request->kd_satuan_beli;
        $bi = $request->beli_isi;
        $sj = $request->kd_satuan_jual;
        $hb = $request->harga_beli;
        $hj = $request->harga_jual;
        $ds = ($request->diskon != null || $request->diskon != '')?$request->diskon:0;
        $ih = $request->id_harga_barang;
        $jpb = $request->jumlah_persatuan_beli;
        $jpj = $request->jumlah_persatuan_jual;


        if($request->id_harga_barang){
            if(count($ih) < count($cek->harga_barang)){
                foreach ($cek->harga_barang as $e) {
                    if(!in_array($e->id, $ih)){
                        try {
                            HargaBarang::find($e->id)->delete();

                        } catch (\Illuminate\Database\QueryException $e) {
                            //dd($e->errorInfo);
                            if($e->errorInfo[1] == 1451){
                                \Session::flash(
                                    "flash_notif",[
                                        "level"   => "dismissible alert-danger",
                                        "massage" => "Data Gagal Di Edit <br><strong>Data Harga Masih Digunakan Di Data Lain</strong></"
                                ]);
                                return redirect()->back();
                            }
                        }
                        
                    }
                }
            }
        }
            
        $harga = [];
        if($sb){
            for ($i=0; $i < count($sb); $i++) { 
                $harga[] = [
                    'kd_barang'=>$cek->kd_barang,
                    'kd_satuan_beli'=>$sb[$i],
                    'beli_isi'=>$bi[$i],
                    'kd_satuan_jual'=>$sj[$i],
                    'harga_beli'=>$hb[$i],
                    'harga_jual'=>$hj[$i],
                    'diskon'=>$ds[$i],
                    'jumlah_persatuan_beli'=>$jpb[$i],
                    'jumlah_persatuan_jual'=>$jpj[$i]
                    
                ];
            }
        }

        
        if($cek){

            
            for ($i=0; $i < count($harga) ; $i++) {
                if(isset($ih[$i])) {
                    $chb = HargaBarang::find($ih[$i]);
                    
                    if($chb->kd_barang != null){

                        $cek2 = $chb->update($harga[$i]);

                    } else {
                        $cek2 = HargaBarang::create($harga[$i]);
                    }
                } else {
                    $cek2 = HargaBarang::create($harga[$i]);
                    
                }
                
                 
                    
            }
            $cek = Barang::find($id);
            
            
           
            // $cek->harga_barang()->delete();
            // $cek2 = HargaBarang::insert($harga);
            if($cek2){
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-success",
                        "massage" => "Data Berhasil Di Edit"
                ]);
                \Helper::add_user_log("Mengubah Data Barang ".$cek->nm_barang);
            } else {
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-danger",
                        "massage" => "Data Gagal Di Edit"
                ]);
                Barang::find($cek->kd_barang)->update([
                    'nm_barang'=>$old_data->nm_barang,
                    'barcode'=>$old_data->barcode,
                    'kd_jenis'=>$old_data->kd_jenis,
                    'kd_merek'=>$old_data->kd_merek,
                    'stok'=>$old_data->stok,
                    'stok_opname'=>$old_data->stok_opname,
                    'stok_minimal'=>$old_data->stok_minimal,
                    'stok_maksimal'=>$old_data->stok_maksimal,
                    'gambar_barang'=>$old_data->gambar_barang
                ]);
                return redirect()->back();
            }
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Edit"
            ]);
            return redirect()->back();
        }
        
        return redirect('barang/'.$id.'/edit');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {   

        if(!\Helper::cek_akses('Barang','Delete')){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Anda Tidak Memiliki Akses"
            ]);

            return redirect('/');
        }
        HargaBarang::where('kd_barang',$id)->delete();
        $cek2 = Barang::where('kd_barang',$id);
        $cek2->delete();
        \Helper::add_user_log("Menghapus Data Barang ".$id);
        return response()->json([
            'success' => 'Record deleted successfully!'
        ]);
    }

    public function deleteAll(Request $request)
    {
        $ids = $request->ids;
        HargaBarang::whereIn('kd_barang',explode(",",$ids))->delete();
        Barang::whereIn('kd_barang',explode(",",$ids))->delete();
        \Helper::add_user_log("Menghapus ".count(explode(",",$ids))." Data Barang ");
        return response()->json(['success'=>"Data Deleted successfully."]);
    }

    public function get_data()
    {
       $s = (isset($_GET['s']))?$_GET['s']:'';
        $kd_jenis = isset($_GET['kd_jenis'])?$_GET['kd_jenis']:'';
        $kd_merek = isset($_GET['kd_merek'])?$_GET['kd_merek']:'';
        $urutkan = isset($_GET['urutkan'])?$_GET['urutkan']:'new';

       
        $datas = Barang::where(function ($q)use($s)
        {
            $q->where('nm_barang','like','%'.$s.'%')->orWhere('barcode','like','%'.$s.'%');
        })->where('kd_jenis','like','%'.$kd_jenis.'%')->where('kd_merek','like','%'.$kd_merek.'%');

        switch ($urutkan) {
            case 'old':
                $datas = Barang::where(function ($q)use($s)
        {
            $q->where('nm_barang','like','%'.$s.'%')->orWhere('barcode','like','%'.$s.'%');
        })->where('kd_jenis','like','%'.$kd_jenis.'%')->where('kd_merek','like','%'.$kd_merek.'%')->orderBy('created_at','ASC')->paginate(10);
                break;
            case 'asc':
                $datas = Barang::where(function ($q)use($s)
        {
            $q->where('nm_barang','like','%'.$s.'%')->orWhere('barcode','like','%'.$s.'%');
        })->where('kd_jenis','like','%'.$kd_jenis.'%')->where('kd_merek','like','%'.$kd_merek.'%')->orderBy('nm_barang','ASC')->paginate(10);
                break;
            case 'desc':
                $datas = Barang::where(function ($q)use($s)
        {
            $q->where('nm_barang','like','%'.$s.'%')->orWhere('barcode','like','%'.$s.'%');
        })->where('kd_jenis','like','%'.$kd_jenis.'%')->where('kd_merek','like','%'.$kd_merek.'%')->orderBy('nm_barang','DESC')->paginate(10);
                break;
            default:
                $datas = Barang::where(function ($q)use($s)
        {
            $q->where('nm_barang','like','%'.$s.'%')->orWhere('barcode','like','%'.$s.'%');
        })->where('kd_jenis','like','%'.$kd_jenis.'%')->where('kd_merek','like','%'.$kd_merek.'%')->orderBy('created_at','DESC')->paginate(10);
                break;
        }


       
        $datas->appends($_GET);

         return view('barang.get_data',compact('datas'));
    }

    public function get_harga($kd_barang)
    {
        $data = Barang::find($kd_barang);
       

        $title = "Barang";
        $url = "barang";
        $menu = "Master Data";
        $no = 1;
       
        return view('barang.get_harga',compact('title','url','menu','no','data'));
    }

    public function cari_barang($barcode)
    {
        $response = ['bool'=>false,'data'=>null];
        $data = Barang::where('barcode',$barcode)->first();
        if(isset($data->kd_barang)){
            $response['bool'] = true;
            $response['barang'] = $data;
        }
        return $response;
    }

    public function cari_barang_kode($kd_barang)
    {
        $response = ['bool'=>false,'data'=>null];
        $data = Barang::where('kd_barang',$kd_barang)->first();
        if(isset($data->kd_barang)){
            $response['bool'] = true;
            $response['barang'] = $data;
        }
        return $response;
    }

    public function cek_harga($idb,$v){
        $b = Barang::find($idb);
        $harga = 0;
        $isi = [];

        $response = ['id_harga_barang'=>0,'harga'=>0];
        foreach ($b->harga_barang as $e) {
            $isi[] = [
                'isi'=>$e->beli_isi,
                'harga'=>$e->harga_jual,
                'id_harga_barang'=>$e->id,
            ];
            
        }

        for ($i=0; $i < count($isi); $i++) { 
            if($isi[$i]['isi'] <= $v && (!isset($isi[$i+1]) || $v < $isi[$i+1]['isi'])){
                
                return $isi[$i];
            }
        }
        return $response;
    }

    public function barcode($id)
    {
        $data = Barang::find($id);
        

       
        return view('barang.barcode',compact('data'));
    }
    
    public function barcodeAll()
    {
        $data = Barang::all();


        return view('barang.barcode_all', compact('data'));
    }


    /**
    * @return \Illuminate\Support\Collection
    */
    public function importExportView()
    {   

        $title = "Import Barang";
        $url = "barang";
        $menu = "Master Data";
        $no = 1;
       return view('barang.import',compact('title','url','menu','no'));
    }
   
    /**
    * @return \Illuminate\Support\Collection
    */
    public function export() 
    {   

        return Excel::download(new BarangsExport, 'barangs-'.date('Y-m-d H:i').'.xlsx');
    }
   
    /**
    * @return \Illuminate\Support\Collection
    */
    public function import() 
    {
        Excel::import(new BarangsImport,request()->file('file'));
        \Session::flash(
            "flash_notif",[
                "level"   => "dismissible alert-success",
                "massage" => "File Berhasil Di Import"
        ]);

        \Helper::add_user_log("Import Data Barang Dari Excel");
           
        return redirect()->back();
    }
}
