<?php
namespace App\Helpers;
 
use Illuminate\Support\Facades\DB;
use App\Profil;
use App\Barang;
use Carbon\Carbon;
use App\UserLog;
use Auth;
use App\Level;
use App\Jenis;
use App\Merek;
use App\Bonus;

use Illuminate\Http\Request;
use Alert;
use Artisan;
use Log;
use Storage;
use Backup;

class Helper {
    /**
     * @param int $user_id User-id
     * 
     * @return string
     */
    public static function get_profil() {
        $profil = Profil::where('dipilih',1)->first();
        return $profil;
    }

    public static function get_kota() {
        $profil = Profil::where('dipilih',1)->first();
        return $profil;
    }

    public static function logo()
    {
        $logo = 'teteslogo.png';
        if(Helper::get_profil()->logo != '' || Helper::get_profil()->logo != null){
            $logo = Helper::get_profil()->logo;
        }
        return $logo;
    }

    public static function logo2()
    {
        $logo = 'tinylite.png';
        if(Helper::get_profil()->logo2 != '' || Helper::get_profil()->logo2 != null){
            $logo = Helper::get_profil()->logo2;
        }
        return $logo;
    }

    public static function jumlah_notif()
    {
        $nb = count(DB::select('select kd_barang from barangs where stok_minimal >= (stok-5)'));
        $jn = $nb;

        return $jn;
    }

    public static function notifikasi_stok_barang()
    {
    	$barangs = DB::select('select * from barangs where stok_minimal >= (stok-5) limit 10');
        ?>
            <?php if(Helper::jumlah_notif() <= 0)echo "<h4>Tidak Ada Notifikasi</h4>"; ?>
            <ul>
        <?php
        foreach ($barangs as $barang) {
            ?>
                <li><a href="<?= url('barang/'.$barang->kd_barang.'/edit') ?>" class="clearfix"><span class="ni w-green"><i class="fa fa-bell"></i></span><span class="notification-message"><?php echo "Stok Barang ".$barang->nm_barang." Sudah Mau Habis!"; ?><span class="notification-time clearfix"><?php echo Carbon::parse($barang->updated_at)->diffForHumans(); ?></span></span></a>
                </li>
            <?php
        }

        ?>
            </ul>
        <?php

    }

    public static function notifikasi_stok_barang_rightbar()
    {
        $barangs = DB::select('select * from barangs where stok_minimal >= (stok-5) order by created_at DESC limit 10 ');
        ?>
            <?php if(Helper::jumlah_notif() <= 0)echo "<h4>Tidak Ada Notifikasi</h4>"; ?>
            <ul>
        <?php
        foreach ($barangs as $barang) {
            ?>
                <li><a href="<?= url('barang/'.$barang->kd_barang.'/edit') ?>" class="clearfix"><span class="ni w-green"><i class="fa fa-bell"></i></span><span class="notification-message"><?php echo "Stok Barang ".$barang->nm_barang." Sudah Mau Habis!"; ?><span class="notification-time clearfix"><?php echo Carbon::parse($barang->updated_at)->diffForHumans(); ?></span></span></a>
                </li>
            <?php
        }

        ?>
            </ul>
            <a href="<?=url('notifikasi');?>" class="btn btn-primary btn-block notification-btn clearfix waves-effect">Selengkepanya</a>
        <?php

    }

    public static function notifikasi_user_log_rightbar()
    {
        $users = UserLog::limit(10)->orderBy('created_at','DESC')->get();
        ?>
            <?php if(Helper::jumlah_notif() <= 0)echo "<h4>Tidak Ada Notifikasi</h4>"; ?>
            <ul>
        <?php
        foreach ($users as $user) {
            ?>
                <li><a href="<?= url('user/'.$user->kd_barang.'/edit') ?>" class="clearfix"><span class="ni w-green"><i class="fa fa-clock-o"></i></span><span class="notification-message"><?php echo $user->user->name." ".$user->keterangan; ?><span class="notification-time clearfix"><?php echo Carbon::parse($user->updated_at)->diffForHumans(); ?></span></span></a>
                </li>
            <?php
        }

        ?>
            </ul>
            <a href="<?=url('user-log');?>" class="btn btn-primary btn-block notification-btn clearfix waves-effect">Selengkepanya</a>
        <?php

    }

    public static function add_user_log($kegiatan)
    {
        UserLog::create(['id_user'=>Auth::user()->id,'keterangan'=>$kegiatan]);
    }


    public static function cek_akses($nama_menu,$aksi){
        $cek = Level::whereHas('Menu',function ($q) use($nama_menu,$aksi)
        {
            $q->where('nm_menu', $nama_menu)
                ->where('aksi_menu', $aksi);
        })->where('id',Auth::user()->level->id)->count();
        if ( $cek > 0 ) {
            return true;
        } else {
            return false;
        }
    }

    public static function list_backup($limit = null)
    {
        $disk = Storage::disk('backup');
        $files = $disk->files(config('backup.backup.name'));
        $backups = [];
        // make an array of backup files, with their filesize and creation date
        $number = 0;
            
        foreach ($files as $k => $f) {
            // only take the zip files into account
            if($limit != null && $number < $limit || $limit == null):
                if (substr($f, -4) == '.zip' && $disk->exists($f)) {
                    $time = \DateTime::createFromFormat("U",$disk->lastModified($f));
                    $time->setTimeZone(new \DateTimeZone('Asia/Kuala_Lumpur'));
                    $backups[] = [
                        'file_path' => $f,
                        'file_name' => str_replace(config('backup.backup.name').'/', '', $f),
                        'file_size' => $disk->size($f),
                        'last_modified' => $disk->lastModified($f),
                        'time'=>$time
                    ];
                }
            endif;
        }
        // reverse the backups, so the newest one would be on top
        $backups = array_reverse($backups);

        return $backups;
    }


    public static function getJenis() {
        return Jenis::all();
    }

    public static function getMerek() {
        return Merek::all();
    }

     public static function notifikasi_status_jasa()
    {
        $jasas = DB::select('select * from jasas where status = 0 limit 10');
        ?>
            <?php if(count(DB::select('select * from jasas where status = 0')) <= 0)echo "<h4>Tidak Ada Notifikasi</h4>"; ?>
            <ul>
        <?php
        foreach ($jasas as $jasa) {
            ?>
                <li><a href="<?= url('jasa/'.$jasa->no_jasa.'/edit') ?>" class="clearfix"><span class="ni w-green"><i class="fa fa-bullhorn"></i></span><span class="notification-message"><?php echo "Transaksi Jasa ".$jasa->no_jasa." Sedang dikerjakan"; ?><span class="notification-time clearfix"><?php echo Carbon::parse($jasa->updated_at)->diffForHumans(); ?></span></span></a>
                </li>
            <?php
        }

        ?>
            </ul>
        <?php

    }

    
    public static function getBonus(){
        $bonus = Bonus::where('id', 1)->first();
        return $bonus;
    }

    // public static function getPoin(){
    //     $poin = Helper::getBonus()->poin;
    //     return $poin;
    // }

    // public static function getPotongan(){
    //     $potongan = Helper::getBonus()->potongan_harga;
    //     return $potongan;
    // }


}