<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class HargaBarang extends Model
{
    protected $guarded = [];


    public function barang()
    {
    	return $this->belongsTo(Barang::class,'kd_barang');
    }

    public function detail_penjualan()
    {
    	return $this->hasMany(DetailPenjualan::class,'id_harga_barang');
    }

    public function satuan_beli()
    {
    	return $this->belongsTo(Satuan::class,"kd_satuan_beli","kd_satuan");
    }

    public function satuan_jual()
    {
    	return $this->belongsTo(Satuan::class,"kd_satuan_jual","kd_satuan");
    }
}
