<?php

namespace App\Exports;

use App\Barang;
use App\HargaBarang;
use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Support\Collection;

class BarangsExport implements FromCollection
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {	

    	$bb = Barang::all();

    	$data = [];
    	$kd_barang = '';
    	foreach ($bb as $b) {

    		if(count($b->harga_barang) <= 0){
    			$data[] = [
    				'barcode'=>$b->barcode,
    				'nm_barang'=>$b->nm_barang,
    				'nm_jenis'=>$b->jenis->nm_jenis,
    				'nm_merek'=>$b->merek->nm_merek,
    				'nm_satuan'=>@$b->satuan_stok->nm_satuan,
    				'stok'=>$b->stok,
    				'stok_opname'=>$b->stok_opname,
    				'stok_minimal'=>$b->stok_minimal,
    				'stok_maksimal'=>$b->stok_maksimal,
    				'harga_beli'=>'',
    				'harga_jual'=>''
	    		];
	    		$kd_barang = $b->kd_barang;
    		} else {
    			foreach ($b->harga_barang as $hb) {
    				if($kd_barang != $b->kd_barang){
		    			$data[] = [
		    				'barcode'=>$b->barcode,
		    				'nm_barang'=>$b->nm_barang,
		    				'nm_jenis'=>$b->jenis->nm_jenis,
		    				'nm_merek'=>$b->merek->nm_merek,
		    				'nm_satuan'=>@$b->satuan_stok->nm_satuan,
		    				'stok'=>$b->stok,
		    				'stok_opname'=>$b->stok_opname,
		    				'stok_minimal'=>$b->stok_minimal,
		    				'stok_maksimal'=>$b->stok_maksimal,
		    				'harga_beli'=>$hb->harga_beli,
		    				'harga_jual'=>$hb->harga_jual
			    		];
			    		$kd_barang = $b->kd_barang;
		    		} else {
		    			$data[] = [
		    				'barcode'=>'',
		    				'nm_barang'=>'',
		    				'nm_jenis'=>'',
		    				'nm_merek'=>'',
		    				'nm_satuan'=>'',
		    				'stok'=>'',
		    				'stok_opname'=>'',
		    				'stok_minimal'=>'',
		    				'stok_maksimal'=>'',
		    				'harga_beli'=>$hb->harga_beli,
		    				'harga_jual'=>$hb->harga_jual
			    		];
			    	}
    			}
    		}
		    		
    	}
    	//dd(collect($data));
    	return collect($data);

        // return Barang::select('barangs.barcode','barangs.nm_barang','kategoris.nm_kategori','jenis.nm_jenis','mereks.nm_merek','satuans.nm_satuan','barangs.stok','barangs.stok_opname','barangs.stok_minimal','barangs.stok_maksimal')->join('jenis','jenis.kd_jenis','barangs.kd_jenis')->join('kategoris','kategoris.kd_kategori','jenis.kd_kategori')->join('mereks','mereks.kd_merek','barangs.kd_merek')->join('satuans','satuans.kd_satuan','barangs.kd_satuan_stok')->get();
    		
    }
}
