<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Barang extends Model
{
    protected $guarded = [];
    protected $primaryKey = "kd_barang";
    public $incrementing = false;


    public function merek()
    {
    	return $this->belongsTo(Merek::class,'kd_merek');
    }

    public function satuan_stok()
    {
        return $this->belongsTo(Satuan::class,'kd_satuan_stok');
    }

    public function jenis()
    {
    	return $this->belongsTo(Jenis::class,'kd_jenis');
    }

    public function harga_barang()
    {
        return $this->hasMany(HargaBarang::class,'kd_barang');
    }

    public function paket()
    {
        return $this->hasMany(DetailPaket::class,'kd_barang', 'kd_barang');
    }


    public function getStokAwalAttribute()
    {    
        $stok_awal = $this->stok;
        $hargas = $this->harga_barang;

        foreach ($hargas as $e) {
            foreach ($e->detail_penjualan as $a) {
                $stok_awal += $a->jumlah;
            }
        }

        return $stok_awal;
    }

    public function getStokTerjualAttribute()
    {    
        $stok = 0;
        $hargas = $this->harga_barang;

        foreach ($hargas as $e) {
            foreach ($e->detail_penjualan as $a) {
                $stok += $a->jumlah;
            }
        }

        return $stok;
    }

   

    public function delete(){
        $this->harga_barang()->delete();
        parent::delete();
    }

    public function getQtyAttribute()
    {
        $qty = 0;
        $hargas = $this->harga_barang;

        foreach ($hargas as $e) {
            foreach ($e->detail_penjualan as $a) {
                $qty += $a->jumlah;
            }
        }

        return $qty;
    }
}
