@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Tambah Permintaan Barang</div>

                <div class="panel-body">
                    <form class="form-horizontal" method="POST" action="{{ url('purchase_request/'.$r->id) }}">
                    	{{ csrf_field() }}
                    	<input type="hidden" name="_method" value="PUT">
						<div class="form-group">
						<label for="nomor" class="col-lg-2 control-label">Nomor Permintaan</label>
						<div class="col-lg-3">
							<input type="text" value="<?php echo @$r->nomor ?>" class="form-control" name="nomor" id="nomor" placeholder="Nomor Permintaan" required >
						</div>
					</div>
					<div class="form-group">
						<label for="tanggal" class="col-lg-2 control-label">Tanggal</label>
						<div class="col-lg-3">
							<input type="date" value="<?php echo @$r->tanggal ?>" class="form-control datepickers" name="tanggal" id="tanggal" placeholder="Tanggal" required>
						</div>
					</div>
					<div class="form-group">
						<label for="merek_id" class="col-lg-2 control-label">Unit</label>
						<div class="col-lg-3">
							<select onchange="getsnen(this.value)" class="form-control selectpicker" name="merek_id" id="merek_id" data-live-search="true">
								<option></option>
								<?php foreach ($merek as $m): ?>
									<option value="<?php echo $m->id ?>" <?php if ($m->id == @$r->merek_id) {echo "selected";} ?>><?php echo $m->kode ?> - <?php echo $m->nama ?></option>
								<?php endforeach ?>				
							</select>
						</div>
					</div>
					<div class="form-group">
						<label for="en_no" class="col-lg-2 control-label">Kode Unit</label>
						<div class="col-lg-3">
							<input type="text" value="<?php echo @$r->kode_unit ?>" class="form-control" name="kode_unit" id="kode_unit" placeholder="Kode Unit">
						</div>
					</div>
				    <div class="form-group">
						<label for="en_no" class="col-lg-2 control-label">E/N No</label>
						<div class="col-lg-3">
							<input type="text" readonly value="<?php echo @$r->merek->no_en ?>" class="form-control" id="en_no" placeholder="E/N No">
						</div>
					</div>
					<div class="form-group">
						<label for="sn_no" class="col-lg-2 control-label">S/N No</label>
						<div class="col-lg-3">
							<input type="text" readonly value="<?php echo @$r->merek->no_sn ?>" class="form-control" id="sn_no" placeholder="S/N No">
						</div>
					</div>
					<div class="form-group">
						<label for="sifat" class="col-lg-2 control-label">Sifat</label>
						<div class="col-lg-3">
							<select class="form-control selectpicker" name="sifat" id="sifat" data-live-search="true">
								<option></option>
								<option value="0" <?php if (@$r->sifat == 0) {echo "selected";} ?>>Biasa</option>
								<option value="1" <?php if (@$r->sifat == 1) {echo "selected";} ?>>Urgent</option>			
							</select>
						</div>
					</div>
					<div class="form-group">
						<label for="destination" class="col-lg-2 control-label">Pilih Tujuan</label>
						<div class="col-lg-3">
							<select class="form-control selectpicker" name="destination" id="destination" data-live-search="true">
								<option value="Camp">Camp</option>
								<option value="Kantor">Kantor</option>	
							</select>
						</div>
					</div>
					<div class="form-group">
						<label for="tanggal" class="col-lg-2 control-label">Keperluan</label>
						<div class="col-lg-3">
							<textarea class="form-control" name="keperluan" id="Keperluan" placeholder="Keperluan" maxlength="255" required><?php echo @$r->keperluan ?></textarea>
						</div>
					</div>
					<div class="form-group">
						<label for="diketahui_id" class="col-lg-2 control-label">Diketahui oleh</label>
						<div class="col-lg-3">
							<select class="form-control selectpicker" name="diketahui_id" id="diketahui_id" data-live-search="true" required>
								<option></option>
								<?php foreach ($user as $u): ?>
									<option value="<?php echo $u->id ?>" <?php if ($u->id == @$r->diketahui_id) {echo "selected";} ?>><?php echo $u->nama ?></option>
								<?php endforeach ?>				
							</select>
							<span style="color:red; font-size:13px" class="help-block">Wajib diisi</span>
						</div>
					</div>
					<div class="form-group">
						<label for="diperiksa_id" class="col-lg-2 control-label">Diperiksa oleh</label>
						<div class="col-lg-3">
							<select class="form-control selectpicker" name="diperiksa_id" id="diperiksa_id" data-live-search="true" required>
								<option></option>
								<?php foreach ($user as $u): ?>
									<option value="<?php echo $u->id ?>" <?php if ($u->id == @$r->diperiksa_id) {echo "selected";} ?>><?php echo $u->nama ?></option>
								<?php endforeach ?>				
							</select>
							<span style="color:red; font-size:13px" class="help-block">Wajib diisi</span>
						</div>
					</div>
					<div class="form-group">
						<label for="disetujui_id" class="col-lg-2 control-label">Disetujui oleh</label>
						<div class="col-lg-3">
							<select class="form-control selectpicker" name="disetujui_id" id="disetujui_id" data-live-search="true" required>
								<option></option>
								<?php foreach ($user as $u): ?>
									<option value="<?php echo $u->id ?>" <?php if ($u->id == @$r->disetujui_id) {echo "selected";} ?>><?php echo $u->nama ?></option>
								<?php endforeach ?>
							</select>
							<span style="color:red; font-size:13px" class="help-block">Wajib diisi</span>
						</div>
					</div>
					<div class="form-group">
						<div class="col-lg-10 col-lg-offset-2">
							
								<button type="submit" class="btn btn-primary">Ubah</button>
								<a class="btn btn-success" href="<?php echo url('purchase_request') ?>">Selesai</a>
							
						</div>
					</div>
				</form>



					<form class="form-inline" method="POST" action="{{ url('detail_purchase_request') }}">
						<input type="hidden" name="permintaan_id" value="<?php echo $r->id ?>">
						{{ csrf_field() }}
						<div class="form-group">
							<select class="form-control selectpicker" name="barang_id" id="barang_id" data-live-search="true">
								<option>Barkode/Kode Barang</option>
								<?php foreach ($barang as $b): ?>
									<option value="<?php echo $b->id ?>"><?php echo $b->kode." - ".$b->nama." - Rp.".number_format($b->harga) ?></option>
								<?php endforeach ?>				
							</select>
						</div>
						<button type="submit" class="btn btn-default">Tambahkan</button>
					</form>
					<p></p>
					<form action="{{ url('detail_purchase_request/'.$r->id) }}" method="POST">
						{{ csrf_field() }}
						<input type="hidden" name="_method" value="PUT">
						<table class="table table-bordered table-hover">
							<thead>
								<tr>
									<th>#</th>
									<th>Kode Barang</th>
									<th>Nama Barang</th>
									<th>Merek</th>
									<th>Merek Unit</th>
									<th>Halaman</th>
									<th>Indeks</th>
									<th width="100px">Jumlah</th>
									<th>Satuan</th>
									<th>Harga</th>
									<th>Keterangan</th>
									<th width="160px">Aksi</th>
								</tr>
							</thead>
							<tbody>
								<?php $no=1 ?>
								<?php foreach ($r->detail as $d): ?>
									<tr>
										
											<input type="hidden" name="id_detail[]" value="<?php echo $d->id ?>">
											
										
											<td><?php echo $no ?></td>
											<td><?php echo $d->barang->kode ?></td>
											<td><?php echo $d->barang->nama ?></td>
											<td><?php echo $d->barang->merek->nama ?></td>
											<td><?php echo $d->barang->merek->unit ?></td>
											<td><?php echo $d->barang->halaman ?></td>
											<td><?php echo $d->barang->indeks ?></td>
											<td>
												<input class="form-control" type="number" name="jumlah[]" value="<?php echo $d->jumlah ?>">
												
											</td>
											<td><?php echo $d->barang->satuan->nama ?></td>
											<td>Rp.<?php echo number_format($d->barang->harga) ?></td>
											<td><?php echo $d->barang->keterangan ?></td>
											<td>
												
												<a class="btn btn-danger" onclick="event.preventDefault();
	                                                     document.getElementById('delete<?php echo $d->id;  ?>').submit();return confirm('Apakah anda yakin akan menghapus data ini?');"><span class="glyphicon glyphicon-remove" aria-hidden="true"></span> Hapus</a>
												
											</td>
										
									</tr>
									<?php $no++ ?>

			                                    
								<?php endforeach ?>
							</tbody>
						</table>
						<button type="submit" class="btn btn-primary">Ubah Detail Permintaan</button>
					</form>

					<?php foreach ($r->detail as $d): ?>
						<form action="{{ url('detail_purchase_request/'.$d->id) }}" id="delete<?php echo $d->id;  ?>" method="POST">
                            {{ csrf_field() }}
                            <input type="hidden" name="_method" value="DELETE">
	                    </form>
                    <?php endforeach ?>


                </div>
            </div>
        </div>
    </div>
</div>
@endsection

