@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Tambah Barang</div>

                <div class="panel-body">
                    <form class="form-horizontal" enctype="multipart/form-data" method="post" accept-charset="utf-8" action="{{ url('item') }}">
                        {{ csrf_field() }}
                        <div class="form-group">

                            <label for="nama" class="col-lg-2 control-label">Nama Barang</label>

                            <div class="col-lg-3">

                                <input type="text"  class="form-control" name="nama" id="nama" placeholder="Nama Barang" required>

                            </div>

                        </div>

                        <div class="form-group">

                            <label for="kode" class="col-lg-2 control-label">No. Part / Barcode</label>

                            <div class="col-lg-3">

                                <input type="text"  class="form-control" name="kode" id="kode" placeholder="No. Part / Barcode Pabrikan" required>

                            </div>

                        </div>

                        <div class="form-group">

                            <label for="kategori_id" class="col-lg-2 control-label">Kategori</label>

                            <div class="col-lg-3">

                                <select class="form-control selectpicker"  name="kategori_id" id="kategori_id" data-live-search="true">

                                    <option></option>   

                                    @foreach ($kategori as $k)

                                        <option value="<?php echo $k->id ?>"><?php echo $k->nama ?></option>

                                    @endforeach            

                                </select>
                                @if ($errors->has('kategori_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('kategori_id') }}</strong>
                                    </span>
                                @endif

                            </div>

                        </div>

                        <div class="form-group">

                            <label for="merek_id" class="col-lg-2 control-label">Unit</label>

                            <div class="col-lg-3">

                                <select class="form-control selectpicker"  name="merek_id" id="merek_id" data-live-search="true">

                                    <option></option>

                                    @foreach ($merek as $j)

                                        <option value="<?php echo $j->id ?>"><?php echo $j->nama ?></option>

                                    @endforeach             

                                </select>
                                @if ($errors->has('merek_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('merek_id') }}</strong>
                                    </span>
                                @endif

                            </div>

                        </div>

                        <div class="form-group">

                            <label for="harga" class="col-lg-2 control-label">Harga Barang</label>

                            <div class="col-lg-3">

                                <input type="text"  class="form-control" name="harga" id="harga" placeholder="Harga Barang" required>

                            </div>

                        </div>

                        <div class="form-group">

                            <label for="halaman" class="col-lg-2 control-label">Halaman</label>

                            <div class="col-lg-3">

                                <input type="text"  class="form-control" name="halaman" id="halaman" placeholder="Halaman" required>

                            </div>

                        </div>

                        <div class="form-group">

                            <label for="indeks" class="col-lg-2 control-label">Indeks</label>

                            <div class="col-lg-3">

                                <input type="text"  class="form-control" name="indeks" id="indeks" placeholder="Indeks" required>

                            </div>

                        </div>

                        <div class="form-group">

                            <label for="satuan_id" class="col-lg-2 control-label">Satuan</label>

                            <div class="col-lg-3">

                                <select class="form-control selectpicker"  name="satuan_id" id="satuan_id" data-live-search="true">

                                    <option></option>

                                    @foreach ($satuan as $s)

                                        <option value="<?php echo $s->id ?>" ><?php echo $s->nama ?></option>

                                    @endforeach          

                                </select>
                                @if ($errors->has('satuan_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('satuan_id') }}</strong>
                                    </span>
                                @endif

                            </div>

                        </div>

                        <div class="form-group">

                            <label for="keterangan" class="col-lg-2 control-label">Keterangan</label>

                            <div class="col-lg-3">

                                <input type="text"  class="form-control" name="keterangan" id="keterangan" placeholder="Keterangan">

                            </div>

                        </div>

                            

                        <div class="form-group">

                            <label for="gambar" class="col-lg-2 control-label">Gambar Barang</label>

                            <div class="col-lg-3">

                                <input type="file" name="userfile" id="userfile" class="form-control">

                            </div>

                        </div>



                        <div class="form-group">

                            <div class="col-lg-10 col-lg-offset-2">

                                <input type=button value=Batal class="btn btn-default" onclick=self.history.back()>

                                <button type="submit" class="btn btn-primary">Simpan</button>

                            </div>

                        </div>

 

                    </form>


                </div>
            </div>
        </div>
    </div>
</div>
@endsection
