@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Atur Supplier</div>

                <div class="panel-body">
                    <form class="form-horizontal" method="POST" action="{{ url('purchase_request/'.$r->id) }}">
                    	{{ csrf_field() }}
                    	<input type="hidden" name="_method" value="PUT">
						<div class="form-group">
							<label for="nomor" class="col-lg-2 control-label">Nomor Permintaan</label>
							<div class="col-lg-3">
								<input type="text" value="<?php echo @$r->nomor ?>" class="form-control" name="nomor" id="nomor" placeholder="Nomor Permintaan" required disabled>
							</div>
						</div>
						<div class="form-group">
							<label for="tanggal" class="col-lg-2 control-label">Tanggal</label>
							<div class="col-lg-3">
								<input type="text" value="<?php echo @$r->tanggal ?>" class="form-control datepickers" name="tanggal" id="tanggal" placeholder="Tanggal" required disabled>
							</div>
						</div>
						<div class="form-group">
							<label for="lokasi_id" class="col-lg-2 control-label">Kantor</label>
							<div class="col-lg-3">
								<select class="form-control selectpicker" name="lokasi_id" id="lokasi_id" data-live-search="true" disabled>
									<option></option>
									<?php foreach ($lokasi as $j): ?>
										<option value="<?php echo $j->id ?>" <?php if ($j->id == @$r->lokasi_id) {echo "selected";} ?>><?php echo $j->nama ?></option>
									<?php endforeach ?>				
								</select>
							</div>
						</div>
						<div class="form-group">
							<label for="merek_id" class="col-lg-2 control-label">Unit</label>
							<div class="col-lg-3">
								<select class="form-control selectpicker" disabled name="merek_id" id="merek_id" data-live-search="true">
									<option></option>
									<?php foreach ($merek as $m): ?>
										<option value="<?php echo $m->id ?>" <?php if ($m->id == @$r->merek_id) {echo "selected";} ?>><?php echo $m->kode ?> - <?php echo $m->nama ?></option>
									<?php endforeach ?>				
								</select>
							</div>
						</div>
					    <div class="form-group">
							<label for="en_no" class="col-lg-2 control-label">Kode Unit</label>
							<div class="col-lg-3">
								<input type="text" disabled value="<?php echo @$r->kode_unit ?>" class="form-control" name="kode_unit" id="kode_unit" placeholder="Kode Unit">
							</div>
						</div>
						<div class="form-group">
							<label for="en_no" class="col-lg-2 control-label">E/N No</label>
							<div class="col-lg-3">
								<input type="text" disabled value="<?php echo @$r->en_no ?>" class="form-control" name="en_no" id="en_no" placeholder="E/N No">
							</div>
						</div>
						<div class="form-group">
							<label for="sn_no" class="col-lg-2 control-label">S/N No</label>
							<div class="col-lg-3">
								<input type="text" disabled value="<?php echo @$r->en_no ?>" class="form-control" name="sn_no" id="sn_no" placeholder="S/N No">
							</div>
						</div>
					    <div class="form-group">
							<label for="sn_no" class="col-lg-2 control-label">Nama Merek</label>
							<div class="col-lg-3">
								<input type="text" disabled value="<?php echo @$r->merek->nama ?>" class="form-control" name="nama_merek" id="sn_no" placeholder="Nama Merek">
							</div>
						</div>
					    <div class="form-group">
							<label for="sn_no" class="col-lg-2 control-label">Merek Unit</label>
							<div class="col-lg-3">
								<input type="text" disabled value="<?php echo @$r->merek->unit ?>" class="form-control" name="merek_unit" id="sn_no" placeholder="Merek Unit">
							</div>
						</div>
						<div class="form-group">
							<label for="sifat" class="col-lg-2 control-label">Sifat</label>
							<div class="col-lg-3">
								<select class="form-control selectpicker" disabled name="sifat" id="sifat" data-live-search="true">
									<option></option>
									<option value="0" <?php if (@$r->sifat == 0) {echo "selected";} ?>>Biasa</option>
									<option value="1" <?php if (@$r->sifat == 1) {echo "selected";} ?>>Urgent</option>			
								</select>
							</div>
						</div>
						<div class="form-group">
							<label for="diketahui_id" class="col-lg-2 control-label">Diketahui oleh</label>
							<div class="col-lg-3">
								<select class="form-control selectpicker" name="diketahui_id" id="diketahui_id" data-live-search="true" disabled>
									<option></option>
									<?php foreach ($user as $u): ?>
										<option value="<?php echo $u->id ?>" <?php if ($u->id == @$r->diketahui_id) {echo "selected";} ?>><?php echo $u->nama ?></option>
									<?php endforeach ?>				
								</select>
							</div>
						</div>
						
						<div class="form-group">
							<div class="col-lg-10 col-lg-offset-2">
								
									
									<a class="btn btn-success" href="<?php echo url('set_supplier') ?>">Selesai</a>
								
							</div>
						</div>
					</form>



				
					<p></p>
					<form action="{{ url('set_supplier/'.$r->id) }}" method="POST">
						{{ csrf_field() }}
						<input type="hidden" name="_method" value="PUT">
					<table class="table table-bordered table-hover">
						<thead>
							<tr>
								<th>#</th>
								<th>Kode Barang</th>
								<th>Nama Barang</th>
								<th>Merek</th>
								<th>Merek Unit</th>
								<th>Halaman</th>
								<th>Indeks</th>
								<th width="100px">Jumlah</th>
								<th>Satuan</th>
								<th>Harga</th>
								<th>Keterangan</th>
								<th>Pemasok</th>
								<th>Status</th>
								
							</tr>
						</thead>
						<tbody>
							<?php $no=1 ?>
							<?php foreach ($r->detail as $d): ?>
								<tr>
									@if($d->status != 2)
										
											<input type="hidden" name="id_detail[]" value="<?php echo $d->id ?>">
											<td><?php echo $no ?></td>
											<td><?php echo $d->barang->kode ?></td>
											<td><?php echo $d->barang->nama ?></td>
											<td><?php echo $d->barang->merek->nama ?></td>
											<td><?php echo $d->barang->merek->unit ?></td>
											<td><?php echo $d->barang->halaman ?></td>
											<td><?php echo $d->barang->indeks ?></td>
											<td>
												<input class="form-control" type="number" name="jumlah[]" value="<?php echo $d->jumlah ?>">
												
											</td>
											<td><?php echo $d->barang->satuan->nama ?></td>
											<td><?php echo $d->harga ?></td>
											<td><textarea name="keterangan[]"><?php echo $d->keterangan ?></textarea></td>
											<td>
												<select class="form-control selectpicker" name="pemasok_id[]" id="pemasok_id" data-live-search="true" required>
													<option></option>
													<?php foreach ($pemasok as $p): ?>
														<option value="<?php echo $p->id ?>" <?php if ($p->id == @$d->pemasok_id) {echo "selected";} ?>><?php echo $p->nama ?></option>
													<?php endforeach ?>				
												</select>
											</td>
											<td>
												<?php if (@$d->status == 1) {echo "Tidak Ada";} ?>
												<?php if (@$d->status == 2) {echo "Ada";} ?>
												<?php if (@$d->status == 3) {echo "Pending";} ?>
											</td>
											
										
									@else
											<td><?php echo $no ?></td>
											<td><?php echo $d->barang->kode ?></td>
											<td><?php echo $d->barang->nama ?></td>
											<td><?php echo $d->barang->merek->nama ?></td>
											<td><?php echo $d->barang->merek->unit ?></td>
											<td><?php echo $d->barang->halaman ?></td>
											<td><?php echo $d->barang->indeks ?></td>
											<td>
												<input disabled class="form-control" type="number" name="jumlah" value="<?php echo $d->jumlah ?>">
												<input disabled type="hidden" name="detail_id" value="<?php echo $d->id ?>">
											</td>
											<td><?php echo $d->barang->satuan->nama ?></td>
											<td><?php echo $d->harga ?></td>
											<td><textarea disabled name="keterangan"><?php echo $d->keterangan ?></textarea></td>
											<td>
												<select disabled class="form-control selectpicker" name="pemasok_id" id="pemasok_id" data-live-search="true" required>
													<option></option>
													<?php foreach ($pemasok as $p): ?>
														<option value="<?php echo $p->id ?>" <?php if ($p->id == @$d->pemasok_id) {echo "selected";} ?>><?php echo $p->nama ?></option>
													<?php endforeach ?>				
												</select>
											</td>
											<td>
												<?php if (@$d->status == 1) {echo "Tidak Ada";} ?>
												<?php if (@$d->status == 2) {echo "Ada";} ?>
												<?php if (@$d->status == 3) {echo "Pending";} ?>
											</td>
											
									@endif
								</tr>
								<?php $no++ ?>
							<?php endforeach ?>
						</tbody>
					</table>
					<button type="submit" class="btn btn-success">Ubah</button>
					</form>




                </div>
            </div>
        </div>
    </div>
</div>
@endsection

