@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Pengguna/User</div>

                <div class="panel-body">
                    <form class="form-inline">
                        <div class="form-group">
                            <input type="text" class="form-control" name="q" placeholder="Pencarian" value="">
                        </div>
                        <button type="submit" class="btn btn-default">Cari</button>
                        <a href="{{ url('user/create') }}" class='btn btn-primary'><span class="glyphicon glyphicon-plus" aria-hidden="true"></span> Tambah Data</a> 
                    </form>
                    <p></p>

                    <table class="table table-bordered table-hover">
                        <tr>
                            <th>No</th>

                            <th>Username</th>

                            <th>Nama</th>

                            <th>Lokasi</th>

                            <th>Jabatan</th>

                            <th>Grup</th>

                            <th>Status</th>

                            <th>Aksi</th>
                        </tr>
                        <?php 
                         $page = 0;
                         if(isset($_GET['page']) && $_GET['page'] > 1){
                            $page = $_GET['page']*10;
                         }
                         $no = 1*$page+1; 
                         ?>
                        @foreach($tables as $t)
                            <tr>
                                <td><?php echo $no ?></td>

                                <td><?php echo $t->username ?></td>

                                <td><?php echo $t->nama ?></td>

                                <td><?php echo $t->lokasi->nama ?></td>

                                <td><?php echo $t->jabatan->nama ?></td>

                                <td><?php echo $t->grup->nama ?></td>

                                <?php 

                                if ($t->active==1) {

                                    $status="Aktif";

                                 }else{

                                    $status="Tidak Aktif";

                                    } 

                                    ?>

                                <td><?php echo $status ?></td>
                                <td>
                                    <a class="btn btn-primary" href="{{ url('user/'.$t->id.'/edit') }}"><span class="glyphicon glyphicon-pencil" aria-hidden="true"></span> Ubah</a>
                                    <a class="btn btn-danger" onclick="event.preventDefault();
                                                    if(confirm('Apakah anda yakin akan menghapus data ini?'))
                                                     document.getElementById('delete<?php echo $t->id;  ?>').submit();"><span class="glyphicon glyphicon-remove" aria-hidden="true"></span> Hapus</a>

                                    <form action="{{ url('user/'.$t->id) }}" id="delete<?php echo $t->id;  ?>" method="POST">
                                        {{ csrf_field() }}
                                        <input type="hidden" name="_method" value="DELETE">
                                    </form>
                                </td>
                            </tr>
                            <?php $no++; ?>
                        @endforeach
                    </table>
                    <center>
                        {{$tables->appends(request()->input())->render()}}
                    </center>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
