@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Tambah Pemesanan Barang</div>

                <div class="panel-body">
                    <form class="form-horizontal" action="<?php echo url('order') ?>" method="POST">
                        {{ csrf_field() }}
                        <input type="hidden" name="pemesanan_baru" id="pemesanan_baru" value="tidak">
                        

                            <div class="form-group">
                                <label for="permintaan_id" class="col-lg-2 control-label">Permintaan Barang</label>
                                <div class="col-lg-3">
                                    <select onchange="get_supplier(this.value)" class="form-control selectpicker" name="permintaan_id" id="permintaan_id" data-live-search="true">
                                        <option></option>
                                        <?php foreach ($permintaan as $p): ?>
                                            <option value="<?php echo $p->id ?>" ><?php echo $p->nomor ?> - <?php echo $p->tanggal ?></option>
                                        <?php endforeach ?>             
                                    </select>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label for="supplier_id" class="col-lg-2 control-label">Supplier Barang</label>
                                <div class="col-lg-3">
                                    <select  class="form-control" onchange="cek_pemesanan(this.value)" name="pemasok_id" id="supplier_id" data-live-search="true" required>
                                        <option value="-1"></option>
                                                  
                                    </select>
                                </div>
                            </div>

                            <div class="form-group">

                                <label for="nama" class="col-lg-2 control-label" >Buat Pemesanan Baru</label>

                                <div class="col-lg-3">

                                    <input type="checkbox" checked="true" name="data_baru" id="data_baru" value="baru">
                                    <span style="color:red; font-size:13px" class="help-block">Jika Ingin Membuat Pemesanan baru centang ini / biarkan saja bila ingin memasukan data ke pemesanan yang sudah ada</span>
                                </div>

                            </div>

                            <div class="form-group">

                                <label for="nama" class="col-lg-2 control-label" >Pilih Pemesanan Lama</label>

                                <div class="col-lg-3">

                                    <input type="checkbox"  name="data_lama" id="data_lama" value="baru">
                                    <span style="color:red; font-size:13px" class="help-block">Jika Ingin Memasukan Data Ini Ke Pemesanan Yang Lain Dengan Supplier Yang Sama Silakan Centang Ini</span>
                                </div>

                                <div class="col-lg-3" id="list_pemesanan_lama">
                                    <select style="border: 1px blue solid;" class="form-control" onchange="get_pemesanan(this.value)" name="pemesanan_lama" id="pemesanan_lama" data-live-search="true">
                                    <option></option>
                                    </select>
                                </div>

                            </div>
                            
                            

                            <div class="form-group">

                                <label for="nama" class="col-lg-2 control-label" >Nomor Pemesanan</label>

                                <div class="col-lg-3">

                                    <input type="text"  class="form-control" name="nomor"  id="nomor"  placeholder="Nomor Pemesanan" required>

                                </div>

                            </div>


                            
                            

                            <div class="form-group">

                                <label for="nama" class="col-lg-2 control-label" >Tanggal Pemesanan</label>

                                <div class="col-lg-3">

                                    <input type="date" class="form-control datepickers" id="tanggal" name="tanggal" placeholder="Tanggal Pemesanan" required >

                                </div>

                            </div>

                            <div class="form-group">

                                <label for="nama" class="col-lg-2 control-label" >Dikirim Ke : </label>

                                <div class="col-lg-3">

                                    <input type="text" class="form-control"  name="dikirim" id="dikirim" placeholder="Dikirim Ke" required >

                                </div>

                            </div>

                            
                        <div class="form-group">
                            <label for="tanggal" class="col-lg-2 control-label">Keterangan</label>
                            <div class="col-lg-3">
                                <textarea class="form-control" name="keterangan" id="keterangan" placeholder="keterangan" maxlength="255" required></textarea>
                            </div>
                        </div>



                        <div class="form-group">
                            <label for="menyetujui" class="col-lg-2 control-label">Disetujui oleh</label>
                            <div class="col-lg-3">
                                <select class="form-control" name="menyetujui" id="menyetujui" data-live-search="true" required>
                                    <option></option>
                                    <?php foreach ($user as $u): ?>
                                        <option value="<?php echo $u->id ?>" ><?php echo $u->nama ?></option>
                                    <?php endforeach ?>             
                                </select>
                                <span style="color:red; font-size:13px" class="help-block">Wajib diisi</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="mengetahui" class="col-lg-2 control-label">Mengetahui oleh</label>
                            <div class="col-lg-3">
                                <select class="form-control" name="mengetahui" id="mengetahui" data-live-search="true" required>
                                    <option></option>
                                    <?php foreach ($user as $u): ?>
                                        <option value="<?php echo $u->id ?>" ><?php echo $u->nama ?></option>
                                    <?php endforeach ?>             
                                </select>
                                <span style="color:red; font-size:13px" class="help-block">Wajib diisi</span>
                            </div>
                        </div>


                        <div class="form-group">
                            <label for="memesan" class="col-lg-2 control-label">Yang Memesan</label>
                            <div class="col-lg-3">
                                <select class="form-control" name="memesan" id="memesan" data-live-search="true" required>
                                    <option></option>
                                    <?php foreach ($user as $u): ?>
                                        <option value="<?php echo $u->id ?>" ><?php echo $u->nama ?></option>
                                    <?php endforeach ?>             
                                </select>
                                <span style="color:red; font-size:13px" class="help-block">Wajib diisi</span>
                            </div>
                        </div>

                        <div class="form-group">

                            <div class="col-lg-10 col-lg-offset-2">

                                <input type=button value=Batal class="btn btn-default" onclick=self.history.back()>

                                <button  type="submit" class="btn btn-primary">Simpan</button>

                            </div>

                        </div>
                        <div id="list-barang">
                            
                        </div>  
                    </form>


                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    var a = 0;
    var b = 0;
    var data_pem;
    $("#list_pemesanan_lama").hide();

    function get_pemesanan(id){
            $.ajax({
                url: '<?php echo url('ajax/get_pemesanan/') ?>/'+id,
                type: 'GET',
                success: function(data) {
                    $("#nomor").val(data.nomor);
                    $("#dikirim").val(data.dikirim);
                    $("#nomor").attr('readonly', 'readonly');
                    $("#dikirim").attr('readonly', 'readonly');
                    $("#pemesanan_baru").attr('disabled', 'disabled');
                    
                    $("#pemesanan_baru").val("iya");
                    $('#data_baru').prop('checked', false);
                    $("#tanggal").val(data.tanggal);
                    $("#tanggal").attr('readonly', 'readonly'); 
                    $("#keterangan").val(data.keterangan);
                    $("#keterangan").attr('readonly', 'readonly'); 
                    $("#menyetujui").val(data.menyetujui);
                    $("#menyetujui").attr('readonly', 'readonly');
                    $("#mengetahui").val(data.mengetahui);
                    $("#mengetahui").attr('readonly', 'readonly');
                    $("#memesan").val(data.memesan);
                    $("#memesan").attr('readonly', 'readonly');
                }
            });
    }
    

    $(document).on('click', '#data_baru', function(event) {
        if(a == 0){
            $("#list_pemesanan_lama").hide();
            $("#pemesanan_lama").html('');
            b = 0;
            $('#data_lama').prop('checked', false);
            $("#nomor").val('');
            $("#dikirim").val('');
            $("#dikirim").removeAttr('readonly');
            $("#nomor").removeAttr('readonly');
            $("#pemesanan_baru").val("tidak");
            $('#data_baru').prop('checked', true);
            $("#pemesanan_baru").removeAttr('disabled');
            $("#tanggal").val('');
            $("#tanggal").removeAttr('readonly'); 
            $("#keterangan").val('');
            $("#keterangan").removeAttr('readonly'); 
            $("#menyetujui").val('');
            $("#menyetujui").removeAttr('readonly'); 
            $("#mengetahui").val('');
            $("#mengetahui").removeAttr('readonly');
            $("#memesan").val('');
            $("#memesan").removeAttr('readonly');
            a = 1;
        }
        else { 
            if(data_pem != null){
                $("#nomor").val(data_pem[0].nomor);
                $("#dikirim").val(data_pem[0].dikirim);
                $("#nomor").attr('readonly', 'readonly');
                $("#dikirim").attr('readonly', 'readonly');
                $("#pemesanan_baru").attr('disabled', 'disabled');
                
                $("#pemesanan_baru").val("iya");
                $('#data_baru').prop('checked', false);
                $("#tanggal").val(data_pem[0].tanggal);
                $("#tanggal").attr('readonly', 'readonly'); 
                $("#keterangan").val(data_pem[0].keterangan);
                $("#keterangan").attr('readonly', 'readonly'); 
                $("#menyetujui").val(data_pem[0].menyetujui);
                $("#menyetujui").attr('readonly', 'readonly');
                $("#mengetahui").val(data_pem[0].mengetahui);
                $("#mengetahui").attr('readonly', 'readonly');
                $("#memesan").val(data_pem[0].memesan);
                $("#memesan").attr('readonly', 'readonly');
            }
                
            a = 0;
        }
    });

    $(document).on('click', '#data_lama', function(event) {
        if(b == 0){
            $("#list_pemesanan_lama").show();
            $('#data_baru').prop('checked', false);
            $.ajax({
                url: '<?php echo url('ajax/get_pemesanan_lama/') ?>/'+$("#supplier_id").val(),
                type: 'GET',
                success: function(data) {
                    if(data == 'false'){
                        alert('pemesanan dengan supplier yang sama tidak ada');
                    }
                    else {
                        $("#pemesanan_lama").html(data);
                    }
                }
            });
            a = 0;
            b = 1;
        }
        else { 
            $("#list_pemesanan_lama").hide();
            $("#pemesanan_lama").html('');
            if(data_pem != null){
                $("#nomor").val(data_pem[0].nomor);
                $("#dikirim").val(data_pem[0].dikirim);
                $("#nomor").attr('readonly', 'readonly');
                $("#dikirim").attr('readonly', 'readonly');
                $("#pemesanan_baru").attr('disabled', 'disabled');
                
                $("#pemesanan_baru").val("iya");
                $('#data_baru').prop('checked', false);
                $("#tanggal").val(data_pem[0].tanggal);
                $("#tanggal").attr('readonly', 'readonly'); 
                $("#keterangan").val(data_pem[0].keterangan);
                $("#keterangan").attr('readonly', 'readonly'); 
                $("#menyetujui").val(data_pem[0].menyetujui);
                $("#menyetujui").attr('readonly', 'readonly');
                $("#mengetahui").val(data_pem[0].mengetahui);
                $("#mengetahui").attr('readonly', 'readonly');
                $("#memesan").val(data_pem[0].memesan);
                $("#memesan").attr('readonly', 'readonly');
            }
            b = 0;
        }
    });

    function get_supplier(id){
        $('#loading-list-menu').show();
        $.ajax({
            url: '<?php echo url('ajax/get_supplier/') ?>/'+id,
            type: 'GET',
            success: function(data) {

                if(data == 'false'){
                    alert("Barang Sudah Di Pesan Semua");
                    $("#nomor").val('');
                    $("#nomor").removeAttr('readonly');
                    $("#pemesanan_baru").val("tidak");
                    
                    $("#pemesanan_baru").removeAttr('disabled');
                    $("#tanggal").val('');
                    $("#tanggal").removeAttr('readonly'); 
                    $("#supplier_id").html('');
                }
                else {
                    $("#supplier_id").html(data);
                    $('.selectpicker').selectpicker();
                    $('#loading-list-menu').hide();
                }
                
            }
           
        }).fail(function() {
            $("#supplier_id").html('');
        }).always(function() {
            $('#loading-list-menu').hide();
        });
        
        
    }

    function get_list_barang_permintaan_barang(id,permintaan_id){
        $.ajax({
            url: '<?php echo url('ajax/get_list_barang_permintaan_barang/') ?>/'+id+'/'+permintaan_id,
            type: 'GET',
            success: function(data) {
                
                $("#list-barang").html(data);
                $('#loading-list-menu').hide();
            }
           
        }).fail(function() {
            $("#list-barang").html('');
        }).always(function() {
            $('#loading-list-menu').hide();
        });
    }


    function cek_pemesanan(id){
        $('#loading-list-menu').show();
        $.ajax({
            url: '<?php echo url('ajax/cek_pemesanan/') ?>/'+id,
            type: 'GET',
            success: function(data) {
                data_pem = null;
                if(data != 'false'){

                    alert("karena pemesanan dengan supllier yang sama sudah ada \nmaka data ini akan di masukan di detail pemesanan yang bernomor "+data[0].nomor);
                    a = 0;
                    data_pem = data;
                    $("#nomor").val(data[0].nomor);
                    $("#dikirim").val(data[0].dikirim);
                    $("#nomor").attr('readonly', 'readonly');
                    $("#dikirim").attr('readonly', 'readonly');
                    $("#pemesanan_baru").attr('disabled', 'disabled');
                    
                    $("#pemesanan_baru").val("iya");
                    $('#data_baru').prop('checked', false);
                    $("#tanggal").val(data[0].tanggal);
                    $("#tanggal").attr('readonly', 'readonly'); 
                    $("#keterangan").val(data[0].keterangan);
                    $("#keterangan").attr('readonly', 'readonly'); 
                    $("#menyetujui").val(data[0].menyetujui);
                    $("#menyetujui").attr('readonly', 'readonly');
                    $("#mengetahui").val(data[0].mengetahui);
                    $("#mengetahui").attr('readonly', 'readonly');
                    $("#memesan").val(data[0].memesan);
                    $("#memesan").attr('readonly', 'readonly');
                    
                }

                else {
                    $("#nomor").val('');
                    $("#dikirim").val('');
                    $("#dikirim").removeAttr('readonly');
                    $("#nomor").removeAttr('readonly');
                    $("#pemesanan_baru").val("tidak");
                    $('#data_baru').prop('checked', true);
                    $("#pemesanan_baru").removeAttr('disabled');
                    $("#tanggal").val('');
                    $("#tanggal").removeAttr('readonly'); 
                }
                get_list_barang_permintaan_barang(id,$("#permintaan_id").val());

                
                $('#loading-list-menu').hide();
            }
           
        }).fail(function() {
            $("#list-barang").html('');
        }).always(function() {
            $('#loading-list-menu').hide();
        });
        
        
    }
</script>
@endsection

