@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Tambah BBM</div>

                <div class="panel-body">
                    <form class="form-horizontal" method="POST" action="{{ url('item_in/'.$r->id) }}">
                        {{ csrf_field() }}
                        <input type="hidden" name="_method" value="PUT">
                        <div class="form-group">
                            <label for="nomor" class="col-lg-2 control-label">Nomor BBM</label>
                            <div class="col-lg-3">
                                <input type="text"  class="form-control" name="nomor" id="nomor" placeholder="Nomor BBM"  value="{{ $r->nomor }}" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="tanggal" class="col-lg-2 control-label">Tanggal</label>
                            <div class="col-lg-3">
                                <input type="date" class="form-control datepickers" name="tanggal" id="tanggal" placeholder="Tanggal" required value="{{ $r->tanggal }}">
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="pemesanan_barang_id" class="col-lg-2 control-label">Pemesanan Barang</label>
                            <div class="col-lg-3">
                                <input type="text" disabled class="form-control" name="pemesanan_barang_id" value="{{ $r->pemesanan->nomor }}">
                            </div>
                        </div>
                            
                            
                        <div class="form-group">
                            <label for="keterangan" class="col-lg-2 control-label">Keterangan</label>
                            <div class="col-lg-3">
                                <input type="text"  class="form-control" name="keterangan" id="keterangan" placeholder="Keterangan" value="{{ $r->keterangan }}">
                            </div>
                        </div>

                        <div class="form-group">

                            <div class="col-lg-10 col-lg-offset-2">

                                <input type=button value=Batal class="btn btn-default" onclick=self.history.back()>

                                <button type="submit" class="btn btn-primary">Simpan</button>

                            </div>

                        </div>
                        
                        <div id="list-barang">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Kode Barang</th>
                                        <th>Nama Barang</th>
                                        <th>Merek</th>
                                        <th>Merek Unit</th>
                                        <th>Halaman</th>
                                        <th>Indeks</th>
                                        <th>SN</th>
                                        
                                        <th>Harga</th>
                                        <th>Jumlah</th>
                                        <th width="170px">Kelengkapan</th>
                                        <th>Satuan</th>
                                        <th>Keterangan</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $no=1 ?>
                                    <?php foreach ($r->detail as $d): ?>
                                        <tr>
                                            <input type="hidden" name="id[]" value="<?php echo $d->id ?>">
                                            <input type="hidden" name="barang_id[]" value="<?php echo $d->barang_id ?>">
                                            <td><?php echo $no ?></td>
                                            <td><?php echo $d->barang->kode ?></td>
                                            <td><?php echo $d->barang->nama ?></td>
                                            <td><?php echo $d->barang->merek->nama ?></td>
                                            <td><?php echo $d->barang->merek->unit ?></td>
                                            <td><?php echo $d->barang->halaman ?></td>
                                            <td><?php echo $d->barang->indeks ?></td>
                                            <td><button type="button" class="btn btn-primary " id="id_<?=$no?>" data-toggle="modal" data-target="#myModal<?=$d->id?>"><i class="glyphicon glyphicon-plus"></i></button></td>
                                            
                                            <td>
                                                <input readonly class="form-control" type="number" name="harga[]" value="<?php echo $d->harga ?>">
                                            </td>
                                            <td>
                                                <input readonly class="form-control" type="number" name="jumlah[]" value="<?php echo $d->jumlah ?>">
                                            </td>
                                            <td>
                                                <select name="kelengkapan[]" class="form-control "   required>
                                                    <option @if($d->kelengkapan == 1) selected @endif value="1">Lengkap</option>
                                                    <option @if($d->kelengkapan == 0) selected @endif value="0">Tidak Lengkap</option>
                                                </select>
                                            </td>
                                            <td><?php echo $d->barang->satuan->nama ?></td>
                                            <td><input type="text" name="detail_keterangan[]" class="form-control" value="<?php echo $d->keterangan ?>"></td>
                                        </tr>
                                        <?php $no++ ?>
                                    <?php endforeach ?>
                                </tbody>
                            </table>
                        </div>

                        <?php foreach ($r->detail as $detail_barang): ?>
                <div id="myModal<?=$detail_barang->id?>" class="modal fade" role="dialog">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                <h4 class="modal-title">Tambah Serial Number</h4>
                            </div>
                            <div class="modal-body" style="padding:0;">
                                
                                    
                                    <table class="table table-bordered table-responsive" style="padding:0">
                                        <thead>
                                            <tr>
                                                <th>Nomor</th>
                                                <th>Serial Number Barang</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $x = 1; ?>
                                            <?php foreach ($detail_barang->serial as $serial): ?>
                                                <tr>
                                                    <input type="hidden" name="serial_id[]" value="{{ $serial->id }}">
                                                    <td valign="midlle"><?php echo $x++ ?></td>
                                                    <td><input type="text" name="sn_<?php echo $serial->id ?>[]" class="form-control input-submit-query" value="<?php echo $serial->sn ?>" placeholder="Serial number <?php echo $detail_barang->barang->nama ?>"></td>
                                                </tr>
                                            <?php endforeach ?>
                                        </tbody>
                                    </table>
                                
                            </div>
                            <div class="modal-footer">
                               
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            </div>
                        </div>

                    </div>
                </div>
            <?php endforeach ?>
                    </form>

                    

                </div>
            </div>
        </div>
    </div>
</div>


            
@endsection
