@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Edit BBK</div>

                <div class="panel-body">
                    <form class="form-horizontal" method="POST" action="{{ url('item_out/'.$r->id) }}">
                        {{ csrf_field() }}
                        <input type="hidden" name="_method" value="PUT">
                        <div class="form-group">
                            <label for="nomor" class="col-lg-2 control-label">Nomor BBK</label>
                            <div class="col-lg-3">
                                <input type="text"  class="form-control" name="nomor" id="nomor" placeholder="Nomor BBK" value="{{ $r->nomor }}" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="tanggal" class="col-lg-2 control-label">Tanggal</label>
                            <div class="col-lg-3">
                                <input type="date" class="form-control datepickers" value="{{ $r->tanggal }}" name="tanggal" id="tanggal" placeholder="Tanggal" required >
                            </div>
                        </div>
                       
                        <div class="form-group">
                            <label for="keterangan" class="col-lg-2 control-label">Keterangan</label>
                            <div class="col-lg-3">
                                <input type="text"  class="form-control" name="keterangan" value="{{ $r->keterangan }}" id="keterangan" placeholder="Keterangan" >
                            </div>
                        </div>
                            
                        <div class="form-group">
                            <label for="halaman" class="col-lg-2 control-label">Halaman</label>
                            <div class="col-lg-3">
                                <input type="number"  class="form-control" name="halaman" id="halaman" placeholder="Halaman" value="{{ $r->halaman }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="dikirim" class="col-lg-2 control-label">Dikirim Melalui</label>
                            <div class="col-lg-3">
                                <input type="text"  class="form-control" name="dikirim" id="dikirim" placeholder="Dikirim Melalui" value="{{ $r->dikirim }}">
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="kepada" class="col-lg-2 control-label">Kepada</label>
                            <div class="col-lg-3">
                                <input type="text"  class="form-control" name="kepada" id="kepada" placeholder="Kepada" value="{{ $r->kepada }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="mengetahui" class="col-lg-2 control-label">Diketahui oleh</label>
                            <div class="col-lg-3">
                                <select class="form-control selectpicker" name="mengetahui" id="mengetahui" data-live-search="true" required>
                                    <option></option>
                                    <?php foreach ($user as $u): ?>
                                        <option @if($u->id == $r->diketahui) selected @endif value="<?php echo $u->id ?>" ><?php echo $u->nama ?></option>
                                    <?php endforeach ?>             
                                </select>
                                <span style="color:red; font-size:13px" class="help-block">Wajib diisi</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="pengantar" class="col-lg-2 control-label">Pengantar oleh</label>
                            <div class="col-lg-3">
                                <select class="form-control selectpicker" name="pengantar" id="pengantar" data-live-search="true" required>
                                    <option></option>
                                    <?php foreach ($user as $u): ?>
                                        <option @if($u->id == $r->pengantar) selected @endif value="<?php echo $u->id ?>" ><?php echo $u->nama ?></option>
                                    <?php endforeach ?>             
                                </select>
                                <span style="color:red; font-size:13px" class="help-block">Wajib diisi</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="penerima" class="col-lg-2 control-label">Penerima oleh</label>
                            <div class="col-lg-3">
                                <select class="form-control selectpicker" name="penerima" id="penerima" data-live-search="true" required>
                                    <option></option>
                                    <?php foreach ($user as $u): ?>
                                        <option @if($u->id == $r->penerima) selected @endif value="<?php echo $u->id ?>" ><?php echo $u->nama ?></option>
                                    <?php endforeach ?>
                                </select>
                                <span style="color:red; font-size:13px" class="help-block">Wajib diisi</span>
                            </div>
                        </div>


                        <div class="form-group">
                            <label for="pengirim" class="col-lg-2 control-label">Pengirim oleh</label>
                            <div class="col-lg-3">
                                <select class="form-control selectpicker" name="pengirim" id="pengirim" data-live-search="true" required>
                                    <option></option>
                                    <?php foreach ($user as $u): ?>
                                        <option @if($u->id == $r->pengirim) selected @endif value="<?php echo $u->id ?>" ><?php echo $u->nama ?></option>
                                    <?php endforeach ?>
                                </select>
                                <span style="color:red; font-size:13px" class="help-block">Wajib diisi</span>
                            </div>
                        </div>

                        <div class="form-group">

                            <div class="col-lg-10 col-lg-offset-2">

                                <input type=button value=Batal class="btn btn-default" onclick=self.history.back()>

                                <button type="submit" class="btn btn-primary">Simpan</button>

                            </div>

                        </div>
                        

                    </form>
                    <div id="list-barang">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>NO PO</th>
                                        <th>NO OPB</th>
                                        <th>Kode Barang</th>
                                        <th>Nama Barang</th>
                                        <th>Merek</th>
                                        <th>Merek Unit</th>
                                        <th>Supplier</th>
                                        <th>Halaman</th>
                                        <th>Indeks</th>
                                        <th>Keterangan</th>
                                        <th>Jumlah</th>
                                        <th>Satuan</th>
                                        <th>Harga</th>
                                        <th>Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $no=1;
                                    $jml_total = 0;
                                      $total = 0;
                                      $jumlahItem = 0;
                                      $jumlahPengeluaran = 0; ?>
                                    <?php foreach ($r->detail as $d): ?>
                                        <tr>
                                            <input type="hidden" name="id[]" value="<?php echo $d->id ?>">
                                            <input type="hidden" name="barang_id[]" value="<?php echo $d->barang_id ?>">
                                            <td><?php echo $no ?></td>
                                            <td><?php echo $d->pemesanan->nomor ?></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                       
                                            <td></td>
                                          
                                            <td>
                                               {{ $d->pemesanan->pemasok->nama }} 
                                            </td>
                                            <td>
                                                
                                            </td>
                                            
                                            <td></td>
                                            <td></td>
                                        </tr>
                                        <?php foreach ($d->pemesanan->bbm as $cc) {
                                                foreach ($cc->detail as $dd) {
                                                    $jumlah_row = $dd->jumlah*$dd->harga;
                                                    ?>
                                                        <tr>
                                                            
                                                            <td></td>
                                                            <td></td>
                                                            <td><?php echo $cc->nomor ?></td>
                                                            <td><?php echo $dd->barang->kode ?></td>
                                                            <td><?php echo $dd->nama_barang ?></td>
                                                            <td><?php echo $dd->barang->merek->nama ?></td>
                                                            <td><?php echo $dd->barang->merek->unit ?></td>
                                                            <td></td>
                                                            <td><?php echo $dd->barang->halaman ?></td>
                                                            <td><?php echo $dd->barang->indeks ?></td>

                                                            <td><?php echo $dd->keterangan ?></td>
                                                            <td>
                                                                <?php echo $dd->jumlah ?>
                                                            </td>
                                                            
                                                            <td><?php echo $dd->barang->satuan->nama ?></td>
                                                            <td>
                                                                Rp.<?php echo number_format($dd->harga) ?>
                                                            </td>
                                                            <td>Rp.{{ number_format($jumlah_row) }}</td>
                                                        </tr>
                                                        <?php $no++ ?>
                                    <?php $jumlahItem += $dd->jumlah; ?>
                                    <?php $jumlahPengeluaran += ($dd->jumlah * $dd->harga); ?>
                                                    <?php

                                                }
                                                
                                           
                                                        
                                            
                                        }  $no++ ?>

                                        
                                    <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td colspan="11" align="right"><b>Total : </b></td>
                                    <td><b><center><?php echo $jumlahItem ?></center></b></td>
                                    <td colspan="6"><b>Rp. <?=number_format($jumlahPengeluaran)?></b></td>
                                </tr>
                            </tfoot>
                            </table>
                        </div>
                    

                </div>
            </div>
        </div>
    </div>
</div>





@endsection
