<?php header("Content-type=application/vhd.ms-excel");
    header("Content-disposition:attachment;filename=".$r->nomor."-".$r->tanggal.".xls"); ?>
<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{$r->nomor."-".$r->tanggal}}</title>

    <!-- Styles -->
    
    <link rel="stylesheet" type="text/css" href="{{ asset('bootstrap/theme/16/bootstrap.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('selectbox/css/bootstrap-select.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('jquery-ui/jquery-ui.min.css') }}">




    <script src="{{ asset('jquery/jquery-1.11.3.min.js') }}"></script>
    <script src="{{ asset('bootstrap/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('selectbox/js/bootstrap-select.min.js') }}"></script>
    <script src="{{ asset('jquery-ui/jquery-ui.min.js') }}"></script>
    <script src="{{ asset('js/bootstrap-notify.min.js') }}" ></script>

    
    <style>
        .ui-datepicker-calendar {
            display: none;
        }
    </style>
    <style type="text/css">

        #gambar{

            float: right; margin-top: -40%; margin-right: auto;

            max-width: 40%;

            max-height: 30%;

        }

        @media screen and (max-width: 1199px) {

          #gambar {

            float: none;

            margin-top: 5px;

            margin-bottom: 5px;

          }

        }



    </style>



</head>
<body>
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading"><h1>Pemesanan Barang</h1></div>

                <div class="panel-body" >
                    <div class="form-horizontal" >
                        
                        <div class="form-group">

                            <label for="nama" class="col-lg-2 control-label">Nomor Pemesanan</label>

                            <div class="col-lg-3">

                                {{ $r->nomor }}

                            </div>

                        </div>

                        <div class="form-group">

                            <label for="nama" class="col-lg-2 control-label">Tanggal Pemesanan</label>

                            <div class="col-lg-3">

                                {{ $r->tanggal }}

                            </div>

                        </div>

                        <div class="form-group">
                            <label for="merek_id" class="col-lg-2 control-label">Permintaan Barang</label>
                            <div class="col-lg-3">
                                {{ $r->permintaan->nomor }}
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="supplier_id" class="col-lg-2 control-label">Supplier Barang</label>
                            <div class="col-lg-3">
                                {{ $r->pemasok->nama }}
                            </div>
                        </div>

                      
                            
                    </div>
                    <p></p>
                    <p></p>
                    <h3>Detail Pemesanan</h3>
                    
                        
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                   
                                    <th>#</th>
                                    <th>Kode Barang</th>
                                    <th>Nama Barang</th>
                                    <th>Merek</th>
                                    <th>Merek Unit</th>
                                    <th>Halaman</th>
                                    <th>Indeks</th>
                                    <th width="100px">Jumlah</th>
                                    <th width="200px">Harga</th>
                                    <th>Satuan</th>
                                    <th>Keterangan</th>
                                   
                                </tr>
                            </thead>
                            <tbody>
                                <?php $no=1 ?>
                                <?php foreach ($r->detail as $d): ?>
                                    <tr>
                                        
                                            
                                           
                                           
                                            <td><?php echo $no ?></td>
                                            <td><?php echo $d->barang->kode ?></td>
                                            <td><?php echo $d->barang->nama ?></td>
                                            <td><?php echo $d->barang->merek->nama ?></td>
                                            <td><?php echo $d->barang->merek->unit ?></td>
                                            <td><?php echo $d->barang->halaman ?></td>
                                            <td><?php echo $d->barang->indeks ?></td>
                                            <td>
                                               <?php echo $d->jumlah ?>
                                                
                                                
                                            </td>
                                            <td>
                                                <?php echo $d->harga ?>
                                            </td>
                                            <td><?php echo $d->barang->satuan->nama ?></td>
                                            <td><?php echo $d->keterangan ?></td>
                                            
                                        
                                    </tr>
                                    <?php $no++ ?>
                                <?php endforeach ?>
                            </tbody>
                        </table>
                        
                    

                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>