@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Tambah BBK</div>

                <div class="panel-body">
                    <form class="form-horizontal" method="POST" action="{{ url('item_out') }}">
                        {{ csrf_field() }}
                        
                        <div class="form-group">
                            <label for="nomor" class="col-lg-2 control-label">Nomor BBK</label>
                            <div class="col-lg-3">
                                <input type="text"  class="form-control" name="nomor" id="nomor" placeholder="Nomor BBK" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="tanggal" class="col-lg-2 control-label">Tanggal</label>
                            <div class="col-lg-3">
                                <input type="date" class="form-control datepickers" name="tanggal" id="tanggal" placeholder="Tanggal" required >
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="bbm_id" class="col-lg-2 control-label">Pemesanan Barang</label>
                            <div class="col-lg-3">
                                <select class="form-control selectpicker" multiple name="pemesanan_barang_id[]" id="pemesanan_barang_id" data-live-search="true" required>
                                    <option></option>
                                    <?php foreach ($pemesanan as $u): ?>

                                    <option value="<?php echo $u->id ?>"><?php echo $u->nomor ?> - <?php echo $u->tanggal ?></option>
                                <?php endforeach ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="keterangan" class="col-lg-2 control-label">Keterangan</label>
                            <div class="col-lg-3">
                                <input type="text"  class="form-control" name="keterangan" id="keterangan" placeholder="Keterangan" >
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="halaman" class="col-lg-2 control-label">Halaman</label>
                            <div class="col-lg-3">
                                <input type="number"  class="form-control" name="halaman" id="halaman" placeholder="Halaman" >
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="dikirim" class="col-lg-2 control-label">Dikirim Melalui</label>
                            <div class="col-lg-3">
                                <input type="text"  class="form-control" name="dikirim" id="dikirim" placeholder="Dikirim Melalui" >
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="kepada" class="col-lg-2 control-label">Kepada</label>
                            <div class="col-lg-3">
                                <input type="text"  class="form-control" name="kepada" id="kepada" placeholder="Kepada" >
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="mengetahui" class="col-lg-2 control-label">Diketahui oleh</label>
                            <div class="col-lg-3">
                                <select class="form-control selectpicker" name="mengetahui" id="mengetahui" data-live-search="true" required>
                                    <option></option>
                                    <?php foreach ($user as $u): ?>
                                        <option value="<?php echo $u->id ?>" ><?php echo $u->nama ?></option>
                                    <?php endforeach ?>             
                                </select>
                                <span style="color:red; font-size:13px" class="help-block">Wajib diisi</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="pengantar" class="col-lg-2 control-label">Pengantar oleh</label>
                            <div class="col-lg-3">
                                <select class="form-control selectpicker" name="pengantar" id="pengantar" data-live-search="true" required>
                                    <option></option>
                                    <?php foreach ($user as $u): ?>
                                        <option value="<?php echo $u->id ?>" ><?php echo $u->nama ?></option>
                                    <?php endforeach ?>             
                                </select>
                                <span style="color:red; font-size:13px" class="help-block">Wajib diisi</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="penerima" class="col-lg-2 control-label">Penerima oleh</label>
                            <div class="col-lg-3">
                                <select class="form-control selectpicker" name="penerima" id="penerima" data-live-search="true" required>
                                    <option></option>
                                    <?php foreach ($user as $u): ?>
                                        <option value="<?php echo $u->id ?>" ><?php echo $u->nama ?></option>
                                    <?php endforeach ?>
                                </select>
                                <span style="color:red; font-size:13px" class="help-block">Wajib diisi</span>
                            </div>
                        </div>


                        <div class="form-group">
                            <label for="pengirim" class="col-lg-2 control-label">Pengirim oleh</label>
                            <div class="col-lg-3">
                                <select class="form-control selectpicker" name="pengirim" id="pengirim" data-live-search="true" required>
                                    <option></option>
                                    <?php foreach ($user as $u): ?>
                                        <option value="<?php echo $u->id ?>" ><?php echo $u->nama ?></option>
                                    <?php endforeach ?>
                                </select>
                                <span style="color:red; font-size:13px" class="help-block">Wajib diisi</span>
                            </div>
                        </div>

                        <div class="form-group">

                            <div class="col-lg-10 col-lg-offset-2">

                                <input type=button value=Batal class="btn btn-default" onclick=self.history.back()>

                                <button type="submit" class="btn btn-primary">Simpan</button>

                            </div>

                        </div>
                        
                        <div id="list-barang">
                        
                        </div>
                    </form>

                    

                </div>
            </div>
        </div>
    </div>
</div>
@endsection
