@extends('layouts.app')

@section('content')
    <div class="mx-auto max-w-screen-2xl p-4 md:p-6 2xl:p-10">
        <div
            class="rounded-sm border border-stroke bg-white px-5 pb-2.5 pt-6 shadow-default dark:border-strokedark dark:bg-boxdark sm:px-7.5 xl:pb-1">
            <h4 class="mb-6 text-xl font-bold text-black dark:text-white">
                Pengguna
            </h4>

            <div class="flex flex-col">
                <div class="mb-4  flex gap-2 flex-col md:flex-row md:flex-row w-full justify-between">
                    <div class="flex gap-2">
                        
                    </div>
                    <div class="flex gap-2 flex-col md:flex-row">
                        <a href="{{ route('user.import-view') }}"
                            class="flex items-center justify-center gap-2 py-2 px-4 rounded-lg bg-success text-white font-medium text-sm hover:bg-primaryhover transition duration-200">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><path fill="currentColor" d="M4 3h14a2 2 0 0 1 2 2v7.08a6 6 0 0 0-4.32.92H12v4h1.08c-.11.68-.11 1.35 0 2H4a2 2 0 0 1-2-2V5c0-1.1.9-2 2-2m0 4v4h6V7zm8 0v4h6V7zm-8 6v4h6v-4zm14.44 2v2h4v2h-4v2l-3-3z"/></svg> Import Pengguna
                        </a>
                        <a href="{{ route('user.create') }}"
                            class="flex items-center justify-center gap-2 py-2 px-4 rounded-lg bg-primary text-white font-medium text-sm hover:bg-primaryhover transition duration-200">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><path fill="currentColor" d="M12 20c-4.41 0-8-3.59-8-8s3.59-8 8-8s8 3.59 8 8s-3.59 8-8 8m0-18A10 10 0 0 0 2 12a10 10 0 0 0 10 10a10 10 0 0 0 10-10A10 10 0 0 0 12 2m1 5h-2v4H7v2h4v4h2v-4h4v-2h-4z"/></svg> Tambah Pengguna
                        </a>
                    </div>

                </div>

                <!-- Table -->
                <div>
                    {{ $dataTable->table() }}
                </div>
              
            </div>
        </div>


    </div>
@endsection


@push('styles')
    <link rel="stylesheet" href="https://cdn.datatables.net/2.1.8/css/dataTables.dataTables.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/2.1.8/css/dataTables.tailwindcss.css">
@endpush

@push('scripts')
    <script src="https://cdn.datatables.net/2.1.8/js/dataTables.js"></script>
    {{ $dataTable->scripts() }}
@endpush