@extends('layouts.app')

@section('content')
    <div class="mx-auto max-w-screen-2xl p-4 md:p-6 2xl:p-10">
        <div
            class="rounded-sm border border-stroke bg-white px-5 pb-2.5 pt-6 shadow-default dark:border-strokedark dark:bg-boxdark sm:px-7.5 xl:pb-1">
            <h4 class="mb-6 text-xl font-bold text-black dark:text-white">
                User Log
            </h4>

            <div class="flex flex-col">
                <div class="mb-4  flex gap-2 flex-col md:flex-row md:flex-row w-full justify-between">
                    <div class="flex gap-2 flex-1">
                        <form class="w-full">
                            <input type="hidden" name="koordinator" value="{{request()->koordinator}}">
                            <div class="grid grid-cols-2 md:grid-cols-4 gap-4 items-end">
                                
                                <div>
                                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                                        Tanggal Awal
                                    </label>
                                    <input type="date" name="tanggal_awal" placeholder="Tanggal Awal..." value="{{ old('tanggal_awal',request()->tanggal_awal) }}"
                                        class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-5 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input" />
                                   
                                </div>
                                <div>
                                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                                        Tanggal Akhir
                                    </label>
                                    <input type="date" name="tanggal_akhir" placeholder="Tanggal Akhir..." value="{{ old('tanggal_akhir',request()->tanggal_akhir) }}"
                                        class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-5 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input" />
                                   
                                </div>
                                <button type="submit" class="flex items-center justify-center  py-2 px-4 rounded-lg bg-primary text-white font-medium text-sm hover:bg-primaryhover transition duration-200">
                                    Filter
                                </button>
                            </div>
                        </form>
                       
                    </div>
                    <div class="flex gap-2 flex-col items-stretch justify-start md:items-start w-full md:w-auto">
                        <a href="{{ route('user-log.index', array_merge(request()->all(), ['export' => 'true'])) }}"
                            class="flex items-center justify-center gap-2 py-2 px-4 rounded-lg bg-success text-white font-medium text-sm hover:bg-primaryhover transition duration-200">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><path fill="currentColor" d="M4 3h14a2 2 0 0 1 2 2v7.08a6 6 0 0 0-4.32.92H12v4h1.08c-.11.68-.11 1.35 0 2H4a2 2 0 0 1-2-2V5c0-1.1.9-2 2-2m0 4v4h6V7zm8 0v4h6V7zm-8 6v4h6v-4zm15.44 8v-2h-4v-2h4v-2l3 3z"/></svg> Export User Log
                        </a>
                        
                    </div>
                </div>

                <!-- Table -->
                <div>
                    {{ $dataTable->table() }}
                </div>
            </div>
        </div>


    </div>
@endsection
@push('styles')
    <link rel="stylesheet" href="https://cdn.datatables.net/2.1.8/css/dataTables.dataTables.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/2.1.8/css/dataTables.tailwindcss.css">
@endpush

@push('scripts')
    <script src="https://cdn.datatables.net/2.1.8/js/dataTables.js"></script>
    {{ $dataTable->scripts() }}
@endpush