@extends('layouts.app')

@section('content')
    <div class="mx-auto max-w-screen-2xl p-4 md:p-6 2xl:p-10">
        <!-- Breadcrumb Start -->
        <div class="mb-6 flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
            <a href="/user-koordinator?koordinator={{request()->koordinator}}"
                class="inline-flex items-center justify-center rounded-md bg-warning px-5 py-2 text-center font-medium text-white hover:bg-opacity-90 lg:px-8 xl:px-10">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                    <g fill="none">
                        <path
                            d="M24 0v24H0V0zM12.593 23.258l-.011.002l-.071.035l-.02.004l-.014-.004l-.071-.035q-.016-.005-.024.005l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427q-.004-.016-.017-.018m.265-.113l-.013.002l-.185.093l-.01.01l-.003.011l.018.43l.005.012l.008.007l.201.093q.019.005.029-.008l.004-.014l-.034-.614q-.005-.019-.02-.022m-.715.002a.02.02 0 0 0-.027.006l-.006.014l-.034.614q.001.018.017.024l.015-.002l.201-.093l.01-.008l.004-.011l.017-.43l-.003-.012l-.01-.01z" />
                        <path fill="currentColor"
                            d="M3.283 10.94a1.5 1.5 0 0 0 0 2.12l5.656 5.658a1.5 1.5 0 1 0 2.122-2.122L7.965 13.5H19.5a1.5 1.5 0 0 0 0-3H7.965l3.096-3.096a1.5 1.5 0 1 0-2.122-2.121z" />
                    </g>
                </svg>
            </a>


            <nav>
                <ol class="flex items-center gap-2">
                    <li>
                        <a class="font-medium" href="/">Dashboard /</a>
                    </li>
                    <li class="font-medium text-primary">Import Koordinator</li>
                </ol>
            </nav>
        </div>
        <!-- Breadcrumb End -->

        <div class="rounded-sm border border-stroke bg-white shadow-default dark:border-strokedark dark:bg-boxdark">
            <div class="border-b border-stroke px-6.5 py-4 dark:border-strokedark">
                <h3 class="font-medium text-black dark:text-white">
                    Import Excel User Koordinator {{Helper::koordinatorLabel(request()->koordinator)}}
                </h3>
            </div>
            <form class="flex flex-col gap-5.5 p-6.5" action="{{route('user-koordinator.import')}}?koordinator={{request()->koordinator}}" method="POST" enctype="multipart/form-data">
                @csrf
                    <div>
                       
                        <small class="text-red-500 block">
                            Beberapa isian data sangat case sensitive, artinya data benar-benar harus sesuai dengan apa yang ada di sistem
                            <ul class="list-disc">
                                <li>
                                    Kolom provinsi wajib huruf besar semua dan tidak disingkat
                                </li>
                                <li>
                                    Kolom kabupaten/kota wajib huruf besar semua, kabupaten ditambahkan dengan kata "KAB. " sedangkan kota ditambahkan kata "KOTA " dan tidak disingkat
                                </li>
                                <li>
                                    Kolom kecamatan wajib huruf besar semua dan tidak disingkat
                                </li>
                                <li>
                                    Kolom kelurahan/desa wajib huruf besar semua dan tidak disingkat
                                </li>
                                <li>
                                    Kolom partai tidak wajib tapi jika ingin diisi wajib sama dengan salah satu nama berikut (PDIP, DEMOKRAT, HANURA, GELORA, PERINDO, UMMAT, Lainnya)
                                </li>
                            </ul>
                        </small>
                        <small class="text-red-500 block">
                            HATI-HATI DATA NO HP DOBEL, PROSES IMPORT AKAN GAGAL JIKA ADA NO HP YANG DOBEL/SUDAH ADA DI SISTEM
                        </small>
                        {{-- @if (request()->koordinator == "kelurahan-desa")
                            <a href="{{  url('format/format_import_user_koordinator_kelurahan_desa.xlsx?t='.date('Ymd')) }}" class=" block mb-3 underline font-bold text-blue-500">Download Format Excel</a>
                        @else
                            <a href="{{  url('format/format_import_user_koordinator.xlsx?t='.date('Ymd')) }}" class=" block mb-3 underline font-bold text-blue-500">Download Format Excel</a>
                        @endif --}}
                        <a href="{{ route('user-koordinator.import-view') }}?koordinator={{request()->koordinator}}&export=true" class=" block mb-3 underline font-bold text-blue-500">Download Format Excel</a>
                        
                        <input type="file" required name="file" accept=".xlsx,.xlx"
                            class="w-full cursor-pointer rounded-lg border-[1.5px] border-stroke bg-transparent font-normal outline-none transition file:mr-5 file:border-collapse file:cursor-pointer file:border-0 file:border-r file:border-solid file:border-stroke file:bg-whiter file:px-5 file:py-3 file:hover:bg-primary file:hover:bg-opacity-10 focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:file:border-form-strokedark dark:file:bg-white/30 dark:file:text-white dark:focus:border-primary" />
                    </div>

                <button type="submit"
                    class="inline-flex items-center justify-center rounded-md bg-primary px-10 py-4 text-center font-medium text-white hover:bg-opacity-90 lg:px-8 xl:px-10">Import</button>
            </form>
        </div>


    </div>
@endsection
