<div class="flex flex-col gap-5.5 p-6.5">
    <div>
        <label class="mb-3 block text-sm font-medium text-black dark:text-white">
            Kelurahan/Desa
        </label>
        <select name="kelurahan_desa_id" class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">
            @foreach ($kelurahanDesas as $kelurahanDesa)
                <option value="{{ $kelurahanDesa->id }}" @if (old('kelurahan_desa_id', @$data->kelurahan_desa_id) == $kelurahanDesa->id) selected @endif>
                    {{ $kelurahanDesa->nama }}
                </option>
            @endforeach
        </select>
        @error('kelurahan_desa_id')
            <span class="text-red-500 text-sm">{{ $message }}</span>
        @enderror
    </div>
    <div>
        <label class="mb-3 block text-sm font-medium text-black dark:text-white">
            Nomor Tps
        </label>
        <input type="text" name="nomor" placeholder="Nomor..." value="{{ old('nomor', @$data->nomor) }}"
            class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
        @error('nomor')
            <span class="text-red-500 text-sm">{{ $message }}</span>
        @enderror
    </div>

    <div>
        <label class="mb-3 block text-sm font-medium text-black dark:text-white">
            Alamat
        </label>
        <input type="text" name="alamat" placeholder="Alamat..." value="{{ old('alamat', @$data->alamat) }}"
            class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
        @error('alamat')
            <span class="text-red-500 text-sm">{{ $message }}</span>
        @enderror
    </div>

    <button type="submit"
        class="inline-flex items-center justify-center rounded-md bg-primary px-10 py-4 text-center font-medium text-white hover:bg-opacity-90 lg:px-8 xl:px-10">Simpan</button>
</div>
