<!DOCTYPE html>
<html lang="id" class="bg-gray-100">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Surat Mandat - Relawan Isran-Hadi</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'pan-blue': '#000080',
                    }
                }
            }
        }
    </script>
</head>

<body class="font-sans text-gray-800 max-w-4xl mx-auto p-4 bg-white shadow-lg my-8" onload="window.print()">
    <div class="flex items-center gap-4 border-b pb-4 mb-6">
        <img src="{{url("/images/isranhadi.png")}}" class="h-24 flex-shrink-0">
        <div>
            <h1 class="text-pan-blue font-bold text-2xl">RELAWAN ISRAN-HADI</h1>
            <h2 class="text-pan-blue font-bold text-xl">KALIMANTAN TIMUR</h2>
            <p class="text-sm mt-2">
                Sekretariat: Jl.Jalan-Jalan<br>
                Telp. (031) 566 9313, 566 96616, Fax (031) 566 9324 - Email: relawan@gmail.com
            </p>
        </div>
    </div>

    <div class="text-center space-y-2 mb-6">
        <h2 class="font-bold text-xl underline">SURAT MANDAT</h2>
        <p>Nomor: ISRHD/13/B/K-S/000/III/{{date("Y")}}</p>
    </div>

    <p class="text-justify mb-6">
        Yang bertanda tangan dibawah ini Tim Pemenangan Isran-Hadi, memberikan mandat kepada saudara:
    </p>

    <div class="space-y-4 mb-6">
        <div class="grid gap-3">
            <div class="grid gap-1.5">
                <label for="nama" class="font-bold">Nama</label>
                {{$saksi->nama}}
                <hr>
            </div>
            <div class="grid gap-1.5">
                <label for="ktp" class="font-bold">No. KTP</label>
                {{$saksi->nik??"-"}}
                <hr>
            </div>
            <div class="grid gap-1.5">
                <label for="gender" class="font-bold">Jenis Kelamin</label>
                {{$saksi->dpt->jenis_kelamin ?? "-"}}
                <hr>
            </div>
            <div class="grid gap-1.5">
                <label for="alamat" class="font-bold">Alamat</label>
                {{$saksi->dpt->alamat ?? "-"}}
                <hr>
            </div>
            <div class="grid gap-1.5">
                <label for="hp" class="font-bold">No. HP/WA</label>
                {{$saksi->no_wa??"-"}}
                <hr>
            </div>
        </div>
    </div>

    <p class="text-justify mb-6">
        Untuk menjadi saksi Tim Pemenangan Isran-Hadi, mengamati proses pemungutan suara dan
        perhitungan suara dalam Pemilu Calon Kepala dan Wakil Kepala Daerah dari jam 07.00 WIB s/d Selesai di:
    </p>

    <div class="space-y-4 mb-6">
        <div class="grid gap-3">
            <div class="grid gap-1.5">
                <label for="tps" class="font-bold">TPS</label>
                {{$saksi->tps->nomor}}
                <hr>
            </div>
            <div class="grid gap-1.5">
                <label for="kelurahan" class="font-bold">Kelurahan/Desa</label>
                {{$saksi->tps->kelurahan_desa->nama}}
                <hr>
            </div>
            <div class="grid gap-1.5">
                <label for="kecamatan" class="font-bold">Kecamatan</label>
                {{$saksi->tps->kelurahan_desa->kecamatan->nama}}
                <hr>
            </div>
            <div class="grid gap-1.5">
                <label for="kabupaten" class="font-bold">Kabupaten/Kota</label>
                {{$saksi->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama}}
                <hr>
            </div>
            <div class="grid gap-1.5">
                <label for="provinsi" class="font-bold">Provinsi</label>
                {{$saksi->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama}}
                <hr>
            </div>
        </div>
    </div>

    <p class="mb-6">
        Demikian Surat Mandat ini kami buat untuk digunakan sebagai mana mestinya.
    </p>

    <div class="text-center mb-6">
        <p>{{$saksi->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama}}, {{date("d F Y")}}</p>
        <p class="font-bold mt-4">Pengurus</p>
        <p class="font-bold">Tim Pemenangan Isran-Hadi</p>
    </div>

    <div class="flex justify-between mt-16">
        <div class="text-center">
            <p class="font-bold underline">Andi</p>
            <p>Ketua</p>
        </div>
        <div class="text-center">
            <p class="font-bold underline">Budi</p>
            <p>Sekretaris</p>
        </div>
    </div>

    <div class="flex justify-end gap-2 mt-8">
        <div class="w-12 h-12 border border-black"></div>
        <div class="w-12 h-12 border border-black"></div>
    </div>
</body>

</html>
