@push('scripts')
    <script>
        document.getElementById("dpt_id").addEventListener('change', function(e) {
            //get option text
            const sel = e.target;
            const text = sel.options[sel.selectedIndex].text;
            const nama = text.split("|")[1].trim();
            const nik = text.split("|")[0].trim();
            document.getElementById("nama").value = nama;
            document.getElementById("nik").value = nik == "null" ? null : nik;
        });
    </script>
@endpush
<div class="grid grid-cols-1 md:grid-cols-2" x-data="{ role: 'saksi' }">
    <div class="flex flex-col gap-5.5 p-6.5">


        <div x-show="role !== 'admin'">
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Provinsi <small class="text-red-500">*</small>
            </label>
            <select name="provinsi_id" id="provinsi_id" required="true"
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">
                <option value="">Pilih Provinsi</option>
                @foreach ($provinsis as $provinsi)
                    <option value="{{ $provinsi->id }}" @if (old('provinsi_id', @$data->provinsi_id) == $provinsi->id) selected @endif>
                        {{ $provinsi->nama }}
                    </option>
                @endforeach
            </select>
            @error('provinsi_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <div x-show="!['admin','koordinator-provinsi'].includes(role)">
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Kabupaten/Kota <small id="loading-kabupaten-kota"></small><small class="text-red-500">*</small>
            </label>
            <select name="kabupaten_kota_id" id="kabupaten_kota_id" required="true"
                class="relative z-20 w-full js-choice appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

            </select>
            @error('kabupaten_kota_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <div x-show="!['admin','koordinator-provinsi','koordinator-kabupaten-kota'].includes(role)">
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Kecamatan <small id="loading-kecamatan"></small><small class="text-red-500">*</small>
            </label>
            <select name="kecamatan_id" id="kecamatan_id" required="true"
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

            </select>
            @error('kecamatan_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <div
            x-show="!['admin','koordinator-provinsi','koordinator-kabupaten-kota','koordinator-kecamatan'].includes(role)">
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Kelurahan/Desa <small id="loading-kelurahan-desa"></small><small class="text-red-500">*</small>
            </label>
            <select name="kelurahan_desa_id" id="kelurahan_desa_id" required="true"
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

            </select>
            @error('kelurahan_desa_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <div x-show="role == 'saksi'">
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                TPS <small id="loading-tps"></small><small class="text-red-500">*</small>
            </label>
            <select name="tps_id" id="tps_id" required="true"
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

            </select>
            @error('tps_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>


        <div x-show="role == 'saksi'">
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                DPT <small id="loading-dpt"></small><small>(Tidak Wajib)</small>
            </label>
            <select name="dpt_id" id="dpt_id"
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

            </select>
            @error('dpt_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>


    </div>

    <div class="flex flex-col gap-5.5 p-6.5">
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Nama Saksi <small class="text-red-500">*</small>
            </label>
            <input required="true"   type="text" id="nama" name="nama" placeholder="Nama..." value="{{ old('nama', @$data->nama) }}"
                class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
            @error('nama')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                NIK <small>(Tidak Wajib)</small>
            </label>
            <div class="flex gap-2">
                <input type="number" maxlength="20" id="nik" name="nik" placeholder="64000..." value="{{ old('nik', @$data->nik ?? @$data->dpt->nik) }}"
                class="flex-1 rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
                <a href="https://cekdptonline.kpu.go.id/" target="_blank" class="flex items-center gap-1 p-1 border rounded-md">
                    <img src="{{asset('images/logo-kpu.png')}}" alt="" style="width: 24px;">
                    <span>Cek DPT</span>
                </a>
            </div>
            
            @error('nik')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Partai <small>(Tidak Wajib)</small>
            </label>
            <select name="partai_id" id="partai_id"
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">
                <option value="">Tidak Ada Partai</option>
                @foreach ($partais as $partai)
                    <option value="{{ $partai->id }}" @if (old('partai_id', @$data->partai_id) == $partai->id) selected @endif>
                        {{ $partai->nama }}
                    </option>
                @endforeach
            </select>
            @error('partai_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        {{-- <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                No Telp Aktif <small class="text-red-500">(Digunakan Sebagai Username)</small> <small class="text-red-500">*</small>
            </label>
            <input type="number" required="true"   maxlength="20" name="no_telp" placeholder="08..."
                value="{{ old('no_telp', @$data->no_telp) }}"
                class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
            @error('no_telp')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div> --}}

        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                No Wa Aktif <small class="text-red-500">(Digunakan Sebagai Username)</small> <small
                    class="text-red-500">*</small>
            </label>
            <input type="number" maxlength="20" minlength="10" required name="no_wa" placeholder="08..."
                value="{{ old('no_wa', @$data->no_wa) }}"
                class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
            @error('no_wa')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Email <small>(Tidak Wajib)</small>
            </label>
            <input type="email" name="email" placeholder="Email..." value="{{ old('email', @$data->email) }}"
                class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
            @error('email')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        @if (isset($data))
            {{-- <div>
                <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                    Password Baru
                </label>
                <input type="password" minlength="5" name="password_baru" placeholder="Password..." value=""
                    class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
                @error('password_baru')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div> --}}
        @else
            {{-- <div>
                <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                    Password
                </label>
                <p class="font-bold">{{$password}}</p>
                <input required="true"   minlength="5" type="hidden" name="password" placeholder="Password..." value="{{$password}}"
                    class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
                @error('password')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div> --}}

            <input minlength="5" type="hidden" name="password" value="{{ $password }}">
        @endif

        <button type="submit"
            class="inline-flex items-center justify-center rounded-md bg-primary px-10 py-4 text-center font-medium text-white hover:bg-opacity-90 lg:px-8 xl:px-10 mt-6">Simpan</button>
    </div>
</div>
