<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>LAPORAN PENDAPATAN HARIAN</title>
    <script src="https://cdn.tailwindcss.com"></script>

    <style>
        body {
            padding: 0px !important;
        }

        table tr td,
        table tr th {
            border: 1px solid rgb(190, 190, 190);
            font-size: 12px !important;
            padding: 6px !important;
        }
    </style>
</head>

<body onload="window.print()">

    <div class="w-full p-6" id="print-element">
        <div class="w-full flex justify-between">
            <div class="flex flex-col w-full">

                <div class="flex justify-between mb-4">
                    <div class="flex justify-center items-center">
                        <div class="flex flex-col">
                            <h1 class="text-xl font-bold">PENGUMUMAN</h1>
                            <p class="mb-4">
                                {{ $pengumuman->user_saksi->nama ?? ($pengumuman->kelurahan_desa->nama ?? ($pengumuman->kecamatan->nama ?? ($pengumuman->kabupaten_kota->nama ?? $_SERVER['SERVER_NAME']))) }}
                            </p>
                        </div>
                    </div>
                    <div class="flex flex-col">
                        <h3 class="text-lg font-bold">{{ $pengumuman->judul }}</h3>
                        <p>{{ $pengumuman->isi }}</p>

                    </div>
                </div>

                <table class="mb-4">
                    <thead>
                        <tr>
                            <th>
                                NO
                            </th>
                            <th>
                                NAMA
                            </th>
                            <th>
                                NO WA
                            </th>
                            <th>
                                PARTAI
                            </th>
                            <th>
                                TPS
                            </th>
                            <th>
                                KELURAHAN/DESA
                            </th>
                            <th>
                                KECAMATAN
                            </th>
                            <th>
                                KABUAPTEN/KOTA
                            </th>
                            <th>
                                IYA
                            </th>
                            <th>
                                TIDAK
                            </th>


                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($pengumuman->pengumuman_jawabs as $index => $jawab)
                            <tr>
                                <td>
                                    {{$loop->iteration}}
                                </td>
                                <td>
                                    {{ @$jawab->user->nama }}
                                </td>
                                <td>
                                    {{ @$jawab->user->no_wa }}
                                </td>
                                <td>
                                    {{ @$jawab->user->partai->nama }}
                                </td>
                                <td>
                                    {{ @$jawab->user->tps->nomor }}
                                </td>
                                <td>
                                    {{ @$jawab->user->tps->kelurahan_desa->nama }}
                                </td>
                                <td>
                                    {{ @$jawab->user->tps->kelurahan_desa->kecamatan->nama }}
                                </td>
                                <td>
                                    {{ @$jawab->user->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama }}
                                </td>
                                @if ($jawab->iya)
                                    <td>
                                        x
                                    </td>
                                    <td>
                                        
                                    </td>
                                @else
                                    <td>
                                        
                                    </td>
                                    <td>
                                        x
                                    </td>
                                @endif
                            </tr>
                        @endforeach
                    </tbody>

                </table>

            </div>

        </div>


    </div>
</body>

</html>
