@extends('layouts.app')

@section('content')
    <div class="mx-auto max-w-screen-2xl p-4 md:p-6 2xl:p-10">
        <div
            class="rounded-sm border border-stroke bg-white px-5 pb-2.5 pt-6 shadow-default dark:border-strokedark dark:bg-boxdark sm:px-7.5 xl:pb-1">
            <h4 class="mb-6 text-xl font-bold text-black dark:text-white">
                Laporan Kegiatan
            </h4>

            <div class="flex flex-col">



                <div class="space-y-4 mb-4">
                    <hr>
                    <p>
                        Tanggal Kegiatan : {{ $laporan->tanggal_kegiatan }}
                    </p>
                    <hr>
                    <p>
                        Uraian Kegiatan : {{ $laporan->uraian_kegiatan }}
                    </p>
                    <hr>
                    <p>
                        Lokasi : {{ $laporan->lokasi }}
                    </p>
                    <hr>
                   
                </div>

                <div class="space-y-4 mb-4">
                    <span >File Absensi : </span>
                    <div class="grid grid-cols-3 gap-2">
                        @foreach ($laporan->list_file_absensi as $index => $file)
                            <div>
                                <a href="{{route('laporan-pelatihan.get-file-absensi',['idLaporan'=>$laporan->id,'index'=>$index])}}" target="_blank">
                                    <img src="{{route('laporan-pelatihan.get-file-absensi',['idLaporan'=>$laporan->id,'index'=>$index])}}" alt="" style="height: 200px;">
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>

                <div class="space-y-4 mb-4">
                    <span >File Dokumentasi : </span>
                    <div class="grid grid-cols-3 gap-2">
                        @foreach ($laporan->list_file_dokumentasi as $index => $file)
                            <div>
                                <a href="{{route('laporan-pelatihan.get-file-dokumentasi',['idLaporan'=>$laporan->id,'index'=>$index])}}" target="_blank">
                                    <img src="{{route('laporan-pelatihan.get-file-dokumentasi',['idLaporan'=>$laporan->id,'index'=>$index])}}" alt="" style="height: 200px;">
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>

                <div class="space-y-4 mb-4">
                    <span >File Anggaran : </span>
                    <div class="pl-4">
                        <ul class="list-disc">
                            @foreach ($laporan->list_file_anggaran as $index => $file)
                                <li>
                                    <a href="{{route('laporan-pelatihan.get-file-anggaran',['idLaporan'=>$laporan->id,'index'=>$index])}}" target="_blank" class="underline text-blue-500">
                                        File Angagran {{$index+1}}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                

            </div>
        </div>


    </div>
@endsection
