<div class="flex flex-col gap-5.5 p-6.5">
    <div>
        <label class="mb-3 block text-sm font-medium text-black dark:text-white">
            Tanggal Kegiatan
        </label>
        <input type="date" name="tanggal_kegiatan" placeholder="Tanggal Kegiatan..."
            value="{{ old('tanggal_kegiatan', @$data->tanggal_kegiatan) }}"
            class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
        @error('tanggal_kegiatan')
            <span class="text-red-500 text-sm">{{ $message }}</span>
        @enderror
    </div>
    <div>
        <label class="mb-3 block text-sm font-medium text-black dark:text-white">
            Uraian Kegiatan
        </label>
        <textarea rows="6" placeholder="Kegiatan..." name="uraian_kegiatan" required
            class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-5 py-3 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary">{{ old('uraian_kegiatan', @$data->uraian_kegiatan) }}</textarea>
        @error('uraian_kegiatan')
            <span class="text-red-500 text-sm">{{ $message }}</span>
        @enderror
    </div>

    <div>
        <label class="mb-3 block text-sm font-medium text-black dark:text-white">
            Lokasi
        </label>
        <input type="text" name="lokasi" placeholder="Lokasi..." value="{{ old('lokasi', @$data->lokasi) }}"
            class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
        @error('lokasi')
            <span class="text-red-500 text-sm">{{ $message }}</span>
        @enderror
    </div>

    <div>
        <label class="mb-3 block text-sm font-medium text-black dark:text-white">
            Upload Absensi <small>(Bisa Lebih Dari Satu)</small>
        </label>

        <input type="file" id="file_absensi" name="file_absensi[]" multiple accept="image/*, .png,.jpg,.jpeg"
            class="w-full cursor-pointer rounded-lg border-[1.5px] border-stroke bg-transparent font-normal outline-none transition file:mr-5 file:border-collapse file:cursor-pointer file:border-0 file:border-r file:border-solid file:border-stroke file:bg-whiter file:px-5 file:py-3 file:hover:bg-primary file:hover:bg-opacity-10 focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:file:border-form-strokedark dark:file:bg-white/30 dark:file:text-white dark:focus:border-primary" />

        <div id="list-file_absensi" class="mt-4"></div>
        <div class="pl-4">
            @if (isset($data))
                <ul class="list-disc">
                    @foreach ($data->list_file_absensi as $index => $file_absensi)
                        <li>
                            <input type="hidden" name="file_absensi_old[]" value="{{ $file_absensi }}">
                            <div class="flex gap-1 items-center">
                                <a href="{{ route('laporan-pelatihan.get-file-absensi', ['idLaporan' => $data->id, 'index' => $index]) }}"
                                    target="_blank">Absensi {{ $index + 1 }}</a>
                                <span class="text-red-500 cursor-pointer" onclick="deleteFile(this)">X</span>
                            </div>
                        </li>
                    @endforeach
                </ul>
            @endif
        </div>
    </div>

    <div>
        <label class="mb-3 block text-sm font-medium text-black dark:text-white">
            Upload Dokumentasi <small>(Bisa Lebih Dari Satu)</small>
        </label>

        <input type="file" id="file_dokumentasi" name="file_dokumentasi[]" multiple accept="image/*, .png,.jpg,.jpeg"
            class="w-full cursor-pointer rounded-lg border-[1.5px] border-stroke bg-transparent font-normal outline-none transition file:mr-5 file:border-collapse file:cursor-pointer file:border-0 file:border-r file:border-solid file:border-stroke file:bg-whiter file:px-5 file:py-3 file:hover:bg-primary file:hover:bg-opacity-10 focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:file:border-form-strokedark dark:file:bg-white/30 dark:file:text-white dark:focus:border-primary" />

        <div id="list-file_dokumentasi" class="mt-4"></div>
        <div class="pl-4">
            @if (isset($data))
                <ul class="list-disc">
                    @foreach ($data->list_file_dokumentasi as $index => $file_dokumentasi)
                        <li>
                            <input type="hidden" name="file_dokumentasi_old[]" value="{{ $file_dokumentasi }}">
                            <div class="flex gap-1 items-center">
                                <a href="{{ route('laporan-pelatihan.get-file-dokumentasi', ['idLaporan' => $data->id, 'index' => $index]) }}"
                                    target="_blank">Dokumentasi {{ $index + 1 }}</a>
                                <span class="text-red-500 cursor-pointer" onclick="deleteFile(this)">X</span>
                            </div>
                        </li>
                    @endforeach
                </ul>
            @endif
        </div>
    </div>

    <div>
        <label class="mb-3 block text-sm font-medium text-black dark:text-white">
            Upload Anggaran <small>(Bisa Lebih Dari Satu)</small>
        </label>

        <input type="file" id="file_anggaran" name="file_anggaran[]" multiple
            accept="application/msword, application/vnd.ms-excel, application/pdf,.xlsx,.xls,.doc, .docx,.pdf"
            class="w-full cursor-pointer rounded-lg border-[1.5px] border-stroke bg-transparent font-normal outline-none transition file:mr-5 file:border-collapse file:cursor-pointer file:border-0 file:border-r file:border-solid file:border-stroke file:bg-whiter file:px-5 file:py-3 file:hover:bg-primary file:hover:bg-opacity-10 focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:file:border-form-strokedark dark:file:bg-white/30 dark:file:text-white dark:focus:border-primary" />

        <div id="list-file_anggaran" class="mt-4"></div>
        <div class="pl-4">
            @if (isset($data))
                <ul class="list-disc">
                    @foreach ($data->list_file_anggaran as $index => $file_anggaran)
                        <li>
                            <input type="hidden" name="file_anggaran_old[]" value="{{ $file_anggaran }}">
                            <div class="flex gap-1 items-center">
                                <a href="{{ route('laporan-pelatihan.get-file-anggaran', ['idLaporan' => $data->id, 'index' => $index]) }}"
                                    target="_blank">Anggaran {{ $index + 1 }}</a>
                                <span class="text-red-500 cursor-pointer" onclick="deleteFile(this)">X</span>
                            </div>
                        </li>
                    @endforeach
                </ul>
            @endif
        </div>
    </div>



    <button type="submit"
        class="inline-flex items-center justify-center rounded-md bg-primary px-10 py-4 text-center font-medium text-white hover:bg-opacity-90 lg:px-8 xl:px-10">Simpan</button>
</div>


@push('scripts')
    <script>
        const fileAbsensi = document.getElementById('file_absensi');
        const fileFileAbsensi = document.getElementById('list-file_absensi');
        const fileDokumentasi = document.getElementById('file_dokumentasi');
        const fileFileDokumentasi = document.getElementById('list-file_dokumentasi');
        const fileAnggaran = document.getElementById('file_anggaran');
        const fileFileAnggaran = document.getElementById('list-file_anggaran');

        fileAbsensi.addEventListener('change', () => {
            fileFileAbsensi.innerHTML = '';
            const files = fileAbsensi.files;
            for (let i = 0; i < files.length; i++) {
                const file = files[i];
                const fileItem = document.createElement('div');
                fileItem.classList.add('flex', 'justify-between', 'items-center', 'mb-2');
                fileItem.innerHTML = `
          <div class="text-gray-700">
            <span class="font-medium">${file.name}</span>
            <span class="text-gray-500 ml-2">(${(file.size / 1024).toFixed(2)} KB)</span>
          </div>
          <div class="text-gray-500">${file.type}</div>
        `;
                fileFileAbsensi.appendChild(fileItem);
            }
        });

        fileDokumentasi.addEventListener('change', () => {
            fileFileDokumentasi.innerHTML = '';
            const files = fileDokumentasi.files;
            for (let i = 0; i < files.length; i++) {
                const file = files[i];
                const fileItem = document.createElement('div');
                fileItem.classList.add('flex', 'justify-between', 'items-center', 'mb-2');
                fileItem.innerHTML = `
          <div class="text-gray-700">
            <span class="font-medium">${file.name}</span>
            <span class="text-gray-500 ml-2">(${(file.size / 1024).toFixed(2)} KB)</span>
          </div>
          <div class="text-gray-500">${file.type}</div>
        `;
                fileFileDokumentasi.appendChild(fileItem);
            }
        });

        fileAnggaran.addEventListener('change', () => {
            fileFileAnggaran.innerHTML = '';
            const files = fileAnggaran.files;
            for (let i = 0; i < files.length; i++) {
                const file = files[i];
                const fileItem = document.createElement('div');
                fileItem.classList.add('flex', 'justify-between', 'items-center', 'mb-2');
                fileItem.innerHTML = `
          <div class="text-gray-700">
            <span class="font-medium">${file.name}</span>
            <span class="text-gray-500 ml-2">(${(file.size / 1024).toFixed(2)} KB)</span>
          </div>
          <div class="text-gray-500">${file.type}</div>
        `;
                fileFileAnggaran.appendChild(fileItem);
            }
        });

        function deleteFile(e) {
            //get parent
            e.parentElement.parentElement.remove();
        }
    </script>
@endpush
