@extends('layouts.app')

@section('content')
    <div class="mx-auto max-w-screen-2xl p-4 md:p-6 2xl:p-10">
        <div
            class="rounded-sm border border-stroke bg-white px-5 pb-2.5 pt-6 shadow-default dark:border-strokedark dark:bg-boxdark sm:px-7.5 xl:pb-1">
            <h4 class="mb-6 text-xl font-bold text-black dark:text-white">
                Kecamatan
            </h4>

            <div class="flex flex-col">
                <div class="mb-4  flex flex-col md:flex-row gap-2 w-full justify-between items-start">
                    <div class="w-full md:w-2/3">
                        <form>
                            
                            <div class="grid grid-cols-2 md:grid-cols-4 gap-4 items-end">
                                <div>
                                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                                        Provinsi
                                    </label>
                                    <select name="provinsi_id" id="provinsi_id"
                                        class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">
                                        <option value="">Pilih Provinsi</option>
                                        @foreach ($provinsis as $provinsi)
                                            <option value="{{ $provinsi->id }}"
                                                @if (old('provinsi_id', request()->provinsi_id) == $provinsi->id) selected @endif>
                                                {{ $provinsi->nama }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('provinsi_id')
                                        <span class="text-red-500 text-sm">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div>
                                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                                        Kabupaten/Kota <small id="loading-kabupaten-kota"></small>
                                    </label>
                                    <select data-pilih-semua="true" name="kabupaten_kota_id" id="kabupaten_kota_id"
                                        class="relative z-20 w-full js-choice appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">
                                    </select>
                                    @error('kabupaten_kota_id')
                                        <span class="text-red-500 text-sm">{{ $message }}</span>
                                    @enderror
                                </div>

                              

                                <button type="submit"
                                    class="flex items-center justify-center max-h-9  py-2 px-4 rounded-lg bg-primary text-white font-medium text-sm hover:bg-primaryhover transition duration-200">
                                    Filter
                                </button>
                            </div>
                        </form>
                    </div>
                    <a href="{{ route('master-data.kecamatan.create') }}"
                        class="flex items-center justify-center gap-2 mt-6 md:mt-0 py-2 px-4 rounded-lg bg-primary text-white font-medium text-sm hover:bg-primaryhover transition duration-200">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><path fill="currentColor" d="M12 20c-4.41 0-8-3.59-8-8s3.59-8 8-8s8 3.59 8 8s-3.59 8-8 8m0-18A10 10 0 0 0 2 12a10 10 0 0 0 10 10a10 10 0 0 0 10-10A10 10 0 0 0 12 2m1 5h-2v4H7v2h4v4h2v-4h4v-2h-4z"/></svg>Tambah Kecamatan
                    </a>
                </div>

                <!-- Table -->
                <div>
                    {{ $dataTable->table() }}
                </div>
              
            </div>
        </div>


    </div>
@endsection

@push('styles')
    <link rel="stylesheet" href="https://cdn.datatables.net/2.1.8/css/dataTables.dataTables.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/2.1.8/css/dataTables.tailwindcss.css">
@endpush

@push('scripts')
    <script src="https://cdn.datatables.net/2.1.8/js/dataTables.js"></script>
    {{ $dataTable->scripts() }}
@endpush