@extends('layouts.app')

@section('content')
    <div class="mx-auto max-w-screen-2xl p-4 md:p-6 2xl:p-10">
        <div class="mx-auto max-w-270">
            <!-- Breadcrumb Start -->
            <div class="mb-6 flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
                <h2 class="text-title-md2 font-bold text-black dark:text-white">
                    Generate Kode OTP
                </h2>

                <nav>
                    <ol class="flex items-center gap-2">
                        <li>
                            <a class="font-medium" href="/">Dashboard /</a>
                        </li>
                        <li class="font-medium text-primary">Generator OTP</li>
                    </ol>
                </nav>
            </div>
            <!-- Breadcrumb End -->

            <!-- ====== Settings Section Start -->
            <div class="w-full">
                <div class="w-full md:w-md mx-auto">
                    <div
                        class="rounded-sm border border-stroke bg-white shadow-default dark:border-strokedark dark:bg-boxdark">
                        <div class="border-b border-stroke px-7 py-4 dark:border-strokedark">

                            <p class="text-red-500">
                                jika ada user yang mengalami kendala login dengan OTP atau kode OTP tidak terkirim, silahkan
                                generate kode OTP secara manual untuk diberikan ke user tersebut.
                            </p>
                        </div>
                        <div class="p-7">
                            <form action="{{ route('generator-otp.generate') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="w-full">
                                    <div class="mb-6">
                                        <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                                            No Wa User <small>(Jika ingin banyak sekaligus pisahkan dengan baris
                                                baru)</small>
                                        </label>
                                        <textarea rows="6" name="no_wa" placeholder="08xxxxxx
08xxxxxx"
                                            class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-5 py-3 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary">{{ old('no_wa', @$no_wa) }}</textarea>
                                        {{-- <input type="number" maxlength="20" minlength="10" required name="no_wa" placeholder="08..."
                            value="{{ old('no_wa', @$no_wa) }}"
                            class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" /> --}}
                                        @error('no_wa')
                                            <span class="text-red-500 text-sm">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div>
                                        <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                                            Atau upload list no wa dalam bentuk excel
                                        </label>
                                        <input type="file" name="file" accept=".xlsx,.xlx,.csv"
                                            class="w-full cursor-pointer rounded-lg border-[1.5px] border-stroke bg-transparent font-normal outline-none transition file:mr-5 file:border-collapse file:cursor-pointer file:border-0 file:border-r file:border-solid file:border-stroke file:bg-whiter file:px-5 file:py-3 file:hover:bg-primary file:hover:bg-opacity-10 focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:file:border-form-strokedark dark:file:bg-white/30 dark:file:text-white dark:focus:border-primary" />
                                    </div>

                                    @if (isset($results))
                                        <div class="pl-4">
                                            <ul class="list-disc">
                                                @foreach ($results as $no_wa => $otp)
                                                    <li class="p-2">
                                                        <div class="flex gap-2 items-center">
                                                            <span>
                                                                {{ $no_wa }} : <b>{{ $otp }}</b>
                                                            </span>
                                                            <button type="button"
                                                                onclick="copyText(this,'{{ $otp }}')"
                                                                class="inline-flex items-center justify-center gap-1 bg-primary px-5 py-2 text-center font-xs text-white hover:bg-opacity-90 lg:px-4 xl:px-5">
                                                                <span>
                                                                    <svg xmlns="http://www.w3.org/2000/svg" width="18"
                                                                        height="18" viewBox="0 0 24 24">
                                                                        <path fill="currentColor"
                                                                            d="M15.24 2h-3.894c-1.764 0-3.162 0-4.255.148c-1.126.152-2.037.472-2.755 1.193c-.719.721-1.038 1.636-1.189 2.766C3 7.205 3 8.608 3 10.379v5.838c0 1.508.92 2.8 2.227 3.342c-.067-.91-.067-2.185-.067-3.247v-5.01c0-1.281 0-2.386.118-3.27c.127-.948.413-1.856 1.147-2.593s1.639-1.024 2.583-1.152c.88-.118 1.98-.118 3.257-.118h3.07c1.276 0 2.374 0 3.255.118A3.6 3.6 0 0 0 15.24 2" />
                                                                        <path fill="currentColor"
                                                                            d="M6.6 11.397c0-2.726 0-4.089.844-4.936c.843-.847 2.2-.847 4.916-.847h2.88c2.715 0 4.073 0 4.917.847S21 8.671 21 11.397v4.82c0 2.726 0 4.089-.843 4.936c-.844.847-2.202.847-4.917.847h-2.88c-2.715 0-4.073 0-4.916-.847c-.844-.847-.844-2.21-.844-4.936z" />
                                                                    </svg>
                                                                </span>
                                                                Copy
                                                            </button>
                                                        </div>

                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif


                                    <button type="submit"
                                        class="inline-flex items-center justify-center rounded-md bg-primary px-10 py-4 text-center font-medium text-white hover:bg-opacity-90 lg:px-8 xl:px-10 mt-6">Generate</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    @endsection

    @push('styles')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
    @endpush

    @push('scripts')
        <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
        <script>
            var notyf = new Notyf();

            function copyText(e, text) {
                // get the container
                const element = e;
                // Create a fake `textarea` and set the contents to the text
                // you want to copy
                const storage = document.createElement('textarea');
                // storage.classList.add('hidden');
                storage.value = text;
                element.appendChild(storage);

                // Copy the text in the fake `textarea` and remove the `textarea`
                storage.select();
                storage.setSelectionRange(0, 99999);
                document.execCommand('copy');
                element.removeChild(storage);
                // navigator.clipboard.writeText(text);
                // alert("Copied the text: " + text);

                notyf.success("Copied code: " + text);
            }
        </script>
    @endpush
