@push('styles')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/choices.js/public/assets/styles/choices.min.css" />
    <style>
        .choices__list--dropdown {
            z-index: 99 !important;
            background-color: white !important;
        }
    </style>
@endpush

@push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/choices.js/public/assets/scripts/choices.min.js"></script>
    <script>
        const provinsiIdChoice = new Choices('#provinsi_id');
        const kabupatenKotaIdChoice = new Choices('#kabupaten_kota_id');
        const kecamatanIdChoice = new Choices('#kecamatan_id');
        const kelurahanDesaIdChoice = new Choices('#kelurahan_desa_id');
        const tpsIdChoice = new Choices('#tps_id');

        const valueProvinsiId = '{{ old("provinsi_id", @$data->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi_id) }}';
        const valueKabupatenKotaId = '{{ old("kabupaten_kota_id", @$data->tps->kelurahan_desa->kecamatan->kabupaten_kota_id) }}';
        const valueKecamatanId = '{{ old("kecamatan_id", @$data->tps->kelurahan_desa->kecamatan_id) }}';
        const valueKelurahanDesaId = '{{ old("kelurahan_desa_id", @$data->tps->kelurahan_desa->id) }}';
        const valueTpsId = '{{ old("tps_id", @$data->tps_id) }}';



        function ajaxKabupatenKota() {
            document.getElementById('loading-kabupaten-kota').innerHTML = 'Loading...';
            const provinsiId = document.getElementById('provinsi_id').value;
            kabupatenKotaIdChoice.clearStore();
            fetch(`/ajax/kabupaten-kota?provinsi_id=${provinsiId}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('loading-kabupaten-kota').innerHTML = '.';
                    kabupatenKotaIdChoice.setChoices(data, 'id', 'nama', false);

                    if (valueKabupatenKotaId) {
                        kabupatenKotaIdChoice.setChoiceByValue(parseInt(valueKabupatenKotaId));
                    }
                })
                .catch(error => {
                    document.getElementById('loading-kabupaten-kota').innerHTML = 'Error';
                });
        }

        function ajaxKecamatan() {
            document.getElementById('loading-kecamatan').innerHTML = 'Loading...';
            const kabupatenKotaId = document.getElementById('kabupaten_kota_id').value != "" ? document.getElementById('kabupaten_kota_id').value : valueKabupatenKotaId;
            kecamatanIdChoice.clearStore();
            fetch(`/ajax/kecamatan?kabupaten_kota_id=${kabupatenKotaId}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('loading-kecamatan').innerHTML = '.';
                    kecamatanIdChoice.setChoices(data, 'id', 'nama', false);

                    if (valueKecamatanId) {
                        kecamatanIdChoice.setChoiceByValue(parseInt(valueKecamatanId));
                    }
                })
                .catch(error => {
                    document.getElementById('loading-kecamatan').innerHTML = 'Error';
                });
        }

        function ajaxKelurahanDesa() {
            document.getElementById('loading-kelurahan-desa').innerHTML = 'Loading...';
            const kecamatanId = document.getElementById('kecamatan_id').value != "" ? document.getElementById('kecamatan_id').value : valueKecamatanId;
            kelurahanDesaIdChoice.clearStore();
            fetch(`/ajax/kelurahan-desa?kecamatan_id=${kecamatanId}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('loading-kelurahan-desa').innerHTML = '.';
                    kelurahanDesaIdChoice.setChoices(data, 'id', 'nama', false);

                    if (valueKelurahanDesaId) {
                        kelurahanDesaIdChoice.setChoiceByValue(parseInt(valueKelurahanDesaId));
                    }
                })
                .catch(error => {
                    document.getElementById('loading-kelurahan-desa').innerHTML = 'Error';
                });
        }

        function ajaxTps() {
            document.getElementById('loading-tps').innerHTML = 'Loading...';
            const kelurahanDesaId = document.getElementById('kelurahan_desa_id').value != "" ? document.getElementById('kelurahan_desa_id').value : valueKelurahanDesaId;
            tpsIdChoice.clearStore();
            fetch(`/ajax/tps?kelurahan_desa_id=${kelurahanDesaId}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('loading-tps').innerHTML = '.';
                    tpsIdChoice.setChoices(data, 'id', 'nomor', false);

                    if (valueTpsId) {
                        tpsIdChoice.setChoiceByValue(parseInt(valueTpsId));
                    }
                })
                .catch(error => {
                    console.log(error);
                    document.getElementById('loading-tps').innerHTML = 'Error';
                });
        }

     
        document.getElementById('provinsi_id').addEventListener('change', function() {
            const provinsiId = this.value;
            kabupatenKotaIdChoice.clearStore();
            ajaxKabupatenKota();
        });

        document.getElementById('kabupaten_kota_id').addEventListener('change', ajaxKecamatan);

        document.getElementById('kecamatan_id').addEventListener('change', ajaxKelurahanDesa);

        document.getElementById('kelurahan_desa_id').addEventListener('change', ajaxTps);

        // document.getElementById('tps_id').addEventListener('change', ajaxDps);

        //on page load
        window.addEventListener('load', function() {
            if (valueProvinsiId) {
                provinsiIdChoice.setChoiceByValue(valueProvinsiId);
                ajaxKabupatenKota();
            }

            if (valueKabupatenKotaId) {
                kabupatenKotaIdChoice.setChoiceByValue(valueKabupatenKotaId);
                ajaxKecamatan();
            }

            if (valueKecamatanId) {
                kelurahanDesaIdChoice.setChoiceByValue(valueKecamatanId);
                ajaxKelurahanDesa();
            }

            if (valueKelurahanDesaId) {
                kelurahanDesaIdChoice.setChoiceByValue(valueKelurahanDesaId);
                ajaxTps();
            }

            // if (valueTpsId) {
            //     ajaxTps();
            // }
        });
    </script>
@endpush

<div class="grid grid-cols-1 md:grid-cols-2" x-data="{ role: 'saksi' }">
    <div class="flex flex-col gap-5.5 p-6.5">


        <div x-show="role !== 'admin'">
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Provinsi
            </label>
            <select name="provinsi_id" id="provinsi_id"
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">
                <option value="">Pilih Provinsi</option>
                @foreach ($provinsis as $provinsi)
                    <option value="{{ $provinsi->id }}" @if (old('provinsi_id', @$data->provinsi_id) == $provinsi->id) selected @endif>
                        {{ $provinsi->nama }}
                    </option>
                @endforeach
            </select>
            @error('provinsi_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <div x-show="!['admin','koordinator-provinsi'].includes(role)">
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Kabupaten/Kota <small id="loading-kabupaten-kota"></small>
            </label>
            <select name="kabupaten_kota_id" id="kabupaten_kota_id"
                class="relative z-20 w-full js-choice appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

            </select>
            @error('kabupaten_kota_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <div x-show="!['admin','koordinator-provinsi','koordinator-kabupaten-kota'].includes(role)">
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Kecamatan <small id="loading-kecamatan"></small>
            </label>
            <select name="kecamatan_id" id="kecamatan_id"
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

            </select>
            @error('kecamatan_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <div
            x-show="!['admin','koordinator-provinsi','koordinator-kabupaten-kota','koordinator-kecamatan'].includes(role)">
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Kelurahan/Desa <small id="loading-kelurahan-desa"></small>
            </label>
            <select name="kelurahan_desa_id" id="kelurahan_desa_id"
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

            </select>
            @error('kelurahan_desa_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <div x-show="role == 'saksi'">
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                TPS <small id="loading-tps"></small>
            </label>
            <select name="tps_id" id="tps_id"
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

            </select>
            @error('tps_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>


    </div>

    <div class="flex flex-col gap-5.5 p-6.5">
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                NIK
            </label>
            <input required type="number" name="nik" placeholder="NIK..." value="{{ old('nik', @$data->nik) }}"
                class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
            @error('nik')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Nama
            </label>
            <input required type="text" name="nama" placeholder="Nama..." value="{{ old('nama', @$data->nama) }}"
                class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
            @error('nama')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Jenis Kelamin
            </label>
            <div class="flex items-center mb-4">
                <input @checked(old("jenis_kelamin",@$data->jenis_kelamin) == "L") id="laki-laki" type="radio" value="L" name="jenis_kelamin"
                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                <label for="laki-laki" class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                    Laki-Laki
                </label>
            </div>
            <div class="flex items-center">
                <input @checked(old("jenis_kelamin",@$data->jenis_kelamin) == "P") id="perempuan" type="radio" value="P" name="jenis_kelamin"
                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                <label for="perempuan" class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                    Perempuan
                </label>
            </div>

        </div>
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Usia
            </label>
            <input required type="number" name="usia" min="0" placeholder="Usia..."
                value="{{ old('usia', @$data->usia) }}"
                class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
            @error('usia')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                RT/RW
            </label>
            <div class="flex gap-2">
                <input required type="number" name="rt" min="0" placeholder="RT..."
                    value="{{ old('rt', @$data->rt) }}"
                    class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
                @error('rt')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
                <input required type="number" name="rw" min="0" placeholder="RW..."
                    value="{{ old('rw', @$data->usia) }}"
                    class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
                @error('rw')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>
        </div>

        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Alamat
            </label>
            <textarea rows="3" name="alamat" placeholder="Alamat..."
                class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary">{{ old('alamat', @$data->alamat) }}</textarea>
            @error('alamat')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        <button type="submit"
            class="inline-flex items-center justify-center rounded-md bg-primary px-10 py-4 text-center font-medium text-white hover:bg-opacity-90 lg:px-8 xl:px-10 mt-6">Simpan</button>
    </div>
</div>
