<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Regional Head Election Results</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/lucide-icons@0.303.0/font/lucide.min.css" rel="stylesheet">
    <style>
        .lucide {
            width: 1em;
            height: 1em;
            stroke-width: 1.5;
            stroke: currentColor;
            fill: none;
            stroke-linecap: round;
            stroke-linejoin: round;
        }
    </style>
</head>
<body class="min-h-screen bg-gray-100 p-4">
    <div class="max-w-md mx-auto bg-white rounded-lg shadow-md overflow-hidden">
        <div class="bg-blue-600 text-white p-4">
            <h1 class="text-xl font-bold text-center">Regional Head Election Results</h1>
        </div>
        <form id="electionForm" class="p-4 space-y-4">
            <div id="candidatesContainer"></div>
            
            <div class="space-y-2 pt-4 border-t">
                <label for="invalid-votes" class="font-medium">Invalid Votes</label>
                <div class="flex items-center space-x-2">
                    <button type="button" class="border rounded-md p-2" onclick="handleInvalidDecrement()" aria-label="Decrease invalid votes">
                        <i class="lucide lucide-minus"></i>
                    </button>
                    <input id="invalid-votes" type="number" value="0" min="0" class="w-full text-center border rounded-md p-2" onchange="handleInvalidVotesChange(this.value)">
                    <button type="button" class="border rounded-md p-2" onclick="handleInvalidIncrement()" aria-label="Increase invalid votes">
                        <i class="lucide lucide-plus"></i>
                    </button>
                </div>
            </div>
            
            <div class="pt-4 border-t">
                <button type="button" id="summaryToggle" class="w-full flex justify-between items-center border rounded-md p-2">
                    Summary
                    <i class="lucide lucide-chevron-down"></i>
                </button>
                <div id="summaryContent" class="mt-2 space-y-2 hidden"></div>
            </div>
            
            <button type="submit" class="w-full bg-green-600 hover:bg-green-700 text-white rounded-md p-2">
                Submit Results
            </button>
        </form>
    </div>

    <script>
        const candidates = [
            { name: 'John Doe', votes: 0 },
            { name: 'Jane Smith', votes: 0 },
            { name: 'Bob Johnson', votes: 0 },
        ];
        let invalidVotes = 0;

        function renderCandidates() {
            const container = document.getElementById('candidatesContainer');
            container.innerHTML = '';
            candidates.forEach((candidate, index) => {
                const div = document.createElement('div');
                div.className = 'space-y-2';
                div.innerHTML = `
                    <label for="candidate-${index}" class="font-medium">${candidate.name}</label>
                    <div class="flex items-center space-x-2">
                        <button type="button" class="border rounded-md p-2" onclick="handleDecrement(${index})" aria-label="Decrease votes for ${candidate.name}">
                            <i class="lucide lucide-minus"></i>
                        </button>
                        <input id="candidate-${index}" type="number" value="${candidate.votes}" min="0" class="w-full text-center border rounded-md p-2" onchange="handleVoteChange(${index}, this.value)">
                        <button type="button" class="border rounded-md p-2" onclick="handleIncrement(${index})" aria-label="Increase votes for ${candidate.name}">
                            <i class="lucide lucide-plus"></i>
                        </button>
                    </div>
                `;
                container.appendChild(div);
            });
        }

        function handleVoteChange(index, votes) {
            candidates[index].votes = Math.max(0, parseInt(votes) || 0);
            updateSummary();
        }

        function handleIncrement(index) {
            candidates[index].votes++;
            document.getElementById(`candidate-${index}`).value = candidates[index].votes;
            updateSummary();
        }

        function handleDecrement(index) {
            candidates[index].votes = Math.max(0, candidates[index].votes - 1);
            document.getElementById(`candidate-${index}`).value = candidates[index].votes;
            updateSummary();
        }

        function handleInvalidVotesChange(votes) {
            invalidVotes = Math.max(0, parseInt(votes) || 0);
            updateSummary();
        }

        function handleInvalidIncrement() {
            invalidVotes++;
            document.getElementById('invalid-votes').value = invalidVotes;
            updateSummary();
        }

        function handleInvalidDecrement() {
            invalidVotes = Math.max(0, invalidVotes - 1);
            document.getElementById('invalid-votes').value = invalidVotes;
            updateSummary();
        }

        function updateSummary() {
            const summaryContent = document.getElementById('summaryContent');
            const totalValidVotes = candidates.reduce((sum, candidate) => sum + candidate.votes, 0);
            const totalVotes = totalValidVotes + invalidVotes;
            
            summaryContent.innerHTML = `
                <p class="font-medium">Total Votes: ${totalVotes}</p>
                <p>Valid Votes: ${totalValidVotes}</p>
                <p>Invalid Votes: ${invalidVotes}</p>
                ${candidates.map(candidate => `
                    <p>${candidate.name}: ${totalValidVotes > 0 ? ((candidate.votes / totalValidVotes) * 100).toFixed(2) : '0'}%</p>
                `).join('')}
            `;
        }

        document.getElementById('summaryToggle').addEventListener('click', function() {
            const summaryContent = document.getElementById('summaryContent');
            const icon = this.querySelector('i');
            if (summaryContent.classList.contains('hidden')) {
                summaryContent.classList.remove('hidden');
                icon.classList.replace('lucide-chevron-down', 'lucide-chevron-up');
            } else {
                summaryContent.classList.add('hidden');
                icon.classList.replace('lucide-chevron-up', 'lucide-chevron-down');
            }
        });

        document.getElementById('electionForm').addEventListener('submit', function(e) {
            e.preventDefault();
            console.log('Submitting results:', { candidates, invalidVotes });
            alert('Results submitted successfully!');
        });

        renderCandidates();
        updateSummary();
    </script>
</body>
</html>