@extends('dashboard-saksi.layouts.app')

@section('content')
    <h1 class="text-3xl font-bold mb-6 text-center">Results</h1>

    <div class="bg-white shadow rounded-lg mb-4">
        <div class="p-4 border-b">
            <h2 class="text-lg font-semibold">TPS : {{ $tps->nomor }} | Kel/Desa : {{ $tps->kelurahan_desa->nama }}</h2>
        </div>

    </div>

    <div class="space-y-4">
        {{-- <p>
        Jumlah DPT : {{$totalDpt}} / {{@$suara->jumlah_dpt ?? 0}}
    </p>
    <hr> --}}
        <div class="bg-white mb-4 overflow-hidden border">
         
            <table class="w-full border-collapse">
                <thead>
                    <tr>
                        <th class="py-2 px-4 text-left w-12 border border-gray-500 bg-gray-300">No</th>
                        <th class="py-2 px-4 text-left border border-gray-500 bg-gray-300">Pasangan Gubernur / Wakil</th>
                       
                    </tr>
                </thead>
                <tbody id="candidatesContainer" class="text-center">
                    @foreach ($calons as $calon)
                    <tr>
                        <td class="py-3 px-4 border border-gray-500" rowspan="2">{{ $calon->nomor }}</td>
                        <td class="py-3 px-4 border border-gray-500">
                            <div class="font-medium">{{ $calon->nama_calon }}</div>
                            <div class="text-sm text-gray-600">{{ $calon->nama_wakil_calon }}</div>
                        </td>
                    </tr>
        
                    <tr>
                        <td class="py-3 px-4 border border-gray-500">
                            {{ $calon->suara_details_sum_jumlah_suara ?? 0 }}
                        </td>
                    </tr>
                       
                    @endforeach
                </tbody>
            </table>
        </div>
        {{-- @foreach ($calons as $calon)
        <div>
            <p>No : {{$calon->nomor}}</p>
            <p>{{$calon->nama_calon}}/{{$calon->nama_wakil_calon}}</p>
            <p>Suara : {{$calon->suara_details_sum_jumlah_suara ?? 0}}</p>
        </div>
    @endforeach --}}


    </div>
@endsection
