@extends('dashboard-saksi.layouts.app')

@section('content')
    <div class="flex items-center p-4 bg-white">
        <div class="flex items-center">
            <div class="w-8 h-8 mr-1 flex justify-center">
                <img src="{{ url('/images/icon-vote.png') }}" alt="" class="object-fill h-8">
            </div>
            <span class="font-semibold">PILKADA 2024</span>
        </div>
    </div>
    {{-- <h1 class="text-3xl font-bold mb-6 text-center">Home</h1> --}}

    {{-- <div class="bg-white shadow rounded-lg mb-4">
    <div class="p-4 border-b">
        <h2 class="text-lg font-semibold">TPS : {{$tps->nomor}} | Kel/Desa : {{$tps->kelurahan_desa->nama}}</h2>
    </div>
    <div class="p-4">
        <div class="grid grid-cols-2 gap-4">
            <div class="text-center">
                <p class="text-2xl font-bold">{{number_format($totalSuara)}}</p>
                <p class="text-sm text-gray-600">Total Votes</p>
            </div>
            <div class="text-center">
                <p class="text-2xl font-bold">{{$jumlahCalon}}</p>
                <p class="text-sm text-gray-600">Calon</p>
            </div>
        </div>
    </div>
</div> --}}

    <div class="mb-8 bg-amber-50 rounded-lg  p-4">
        <h2 class="text-xl font-bold mb-2">{{ auth()->user()->nama }}</h2>
        <p class="text-gray-600 text-sm">Saksi</p>
        <div class="flex justify-between">
            <div>
                <p class="text-sm">Kel/Desa: {{ $tps->kelurahan_desa->nama }}</p>
                <p class="text-sm text-gray-400">Koordinator Desa</p>
                <p class="text-sm min-h-3">{{ $user_koordes }}</p>
                <p class="text-sm text-gray-400">Koordinator Kecamatan</p>
                <p class="text-sm min-h-3">{{ $user_koorcam }}</p>
            </div>
            <div class="flex-1 min-w-12">
                <p class="text-sm">TPS: {{ $tps->nomor }}</p>
            </div>
        </div>
    </div>

    <div class="flex justify-around mb-6 gap-10">
        <a href="{{ route('user-saksi.input-suara.index') }}" class="flex flex-col items-center w-1/2 px-2">
            <div class="bg-white rounded-lg shadow p-4 w-full flex flex-col items-center">
                <div class="mb-2">
                    <img src="{{ url('/images/icon_kotak_suara.png') }}" alt="">
                </div>
                <span class="text-sm font-medium">Input Suara</span>
            </div>
        </a>
        <a href="{{ route('user-saksi.input-lampiran.index') }}" class="flex flex-col items-center w-1/2 px-2">
            <div class="bg-white rounded-lg shadow p-4 w-full flex flex-col items-center">
                <div class="mb-2">
                    <img src="{{ url('/images/icon_kotak_suara.png') }}" alt="">
                </div>
                <span class="text-sm font-medium">Upload Foto</span>
            </div>
        </a>
    </div>

    <div class="space-y-4">

        {{-- <a href="{{ route('user-saksi.input-suara.index') }}"
            class="w-full flex justify-between items-center px-4 py-2 bg-white text-gray-800 border border-gray-300 rounded-md hover:bg-gray-50 transition-colors">
            Input Suara
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd"
                    d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z"
                    clip-rule="evenodd" />
            </svg>
        </a>
        <a href="{{ route('user-saksi.input-lampiran.index') }}"
            class="w-full flex justify-between items-center px-4 py-2 bg-white text-gray-800 border border-gray-300 rounded-md hover:bg-gray-50 transition-colors">
            Upload File
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd"
                    d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z"
                    clip-rule="evenodd" />
            </svg>
        </a> --}}
        <a href="https://play.google.com/store/apps/details?id=com.isranhadi.saksi_pilkada"
            class="w-full flex justify-between items-center px-4 py-2 bg-white text-gray-800 border border-gray-300 rounded-md hover:bg-gray-50 transition-colors gap-2"
            target="_blank">
            <img src="{{ url('/images/google-play-store-icon-logo-symbol-free-png.png') }}" alt=""
                style="width: 100px;">
            <span>Download Aplikasi <b>Saksi Pilkada 2024</b> Mobile Di Playstore</span>

        </a>

    </div>
@endsection
