@extends('dashboard-saksi.layouts.app')

@section('content')
<h1 class="text-3xl font-bold mb-6 text-center">Change Password</h1>
            

<div class="space-y-4">
    <form class="p-4 space-y-4" action="{{ route('user-saksi.change-password.change') }}" method="POST">
        @csrf
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Password Lama
            </label>
            <input type="password" required minlength="5" name="password_lama" placeholder="Password..." value=""
                class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
            @error('password_lama')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Password Baru
            </label>
            <input type="password" required minlength="5" name="password_baru" placeholder="Password..." value=""
                class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
            @error('password_baru')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        <button type="submit" class="w-full bg-green-600 hover:bg-green-700 text-white rounded-md p-2">
            Submit
        </button>
    </form>
    
</div>
@endsection
