<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>OTP Verification</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        /* Chrome, Safari, Edge, Opera */
        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        /* Firefox */
        input[type=number] {
            -moz-appearance: textfield;
        }
    </style>
</head>

<body class="bg-gray-100 min-h-screen flex items-center justify-center">
    <div class="bg-white p-8 rounded-lg shadow-md w-full max-w-md">
        <h1 class="text-2xl font-bold text-center mb-6">OTP Verification</h1>
        <p class="text-gray-600 text-center mb-6">
            Kami telah mengirimkan OTP 6 digit ke whatsapp Anda <span class="text-green-500">{{ $no_wa }}</span>.
            Silakan masukkan di bawah ini untuk memverifikasi akun Anda.
        </p>
        <form id="otpForm" class="space-y-4" method="POST" action="{{ route('cek-otp.auth', $no_wa) }}">
            @csrf
            <input type="hidden" name="no_wa" value="{{ $no_wa }}">
            @session('error')
                <div class="mb-4">
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                        <strong class="font-bold">Error!</strong>
                        <span class="block sm:inline">{{ session('error') }}</span>
                    </div>
                </div>
            @endsession
            @session('warning')
                <div class="mb-4">
                    <div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded relative"
                        role="alert">
                        <strong class="font-bold">Warning!</strong>
                        <span class="block sm:inline">{{ session('warning') }}</span>
                    </div>
                </div>
            @endsession
            <div class="flex justify-between">
                <input type="number" maxlength="1" name="no_1"
                    class="w-12 h-12 text-center text-2xl border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                    required>
                <input type="number" maxlength="1" name="no_2"
                    class="w-12 h-12 text-center text-2xl border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                    required>
                <input type="number" maxlength="1" name="no_3"
                    class="w-12 h-12 text-center text-2xl border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                    required>
                <input type="number" maxlength="1" name="no_4"
                    class="w-12 h-12 text-center text-2xl border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                    required>
                <input type="number" maxlength="1" name="no_5"
                    class="w-12 h-12 text-center text-2xl border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                    required>
                <input type="number" maxlength="1" name="no_6"
                    class="w-12 h-12 text-center text-2xl border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                    required>
            </div>
            <button type="submit" id="submitForm"
                class="w-full bg-blue-500 text-white py-2 rounded-md hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                Verifikasi OTP
            </button>
        </form>
        <form action="{{ route('cek-otp.resend', $no_wa) }}" method="POST" id="resendOtpForm">
            @csrf
            <p class="text-center mt-4 text-sm text-gray-600" id="resendText">
                Tidak mendapatkan kode OTP ?
                <button type="submit" href="#" class="text-blue-500 hover:underline" id="resendOTP">
                    Kirim Ulang OTP
                </button>
            </p>
            <p id="countdownText" class="hidden text-center mt-4 text-sm text-gray-600">
                Anda dapat mengirim OTP lagi dalam <span id="countdownTimer" class="font-bold"></span> detik
            </p>
            @if (isset($kontakAdmins) && count($kontakAdmins) > 0)
                <div class=" mt-4 text-sm text-gray-600 block m-auto">
                    <p>Jika ada kendala atau pertanyaan silahkan hubungi : </p>
                    <ul class="ml-2 list-disc">
                        @foreach ($kontakAdmins as $kontakAdmin)
                            <li>{{ $kontakAdmin['nama'] }} - <a
                                    href="https://api.whatsapp.com/send?phone=62{{ substr($kontakAdmin['no_wa'], 1) }}&text=Saya%20perlu%20bantuan%20mengenai%20login%20aplikasi"
                                    target="_blank"><b>{{ $kontakAdmin['no_wa'] }}</b></a> </li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </form>
    </div>

    <script>
        const form = document.getElementById('otpForm');
        const inputs = form.querySelectorAll('input[type="number"]');
        const errorMessage = document.getElementById('errorMessage');
        const resendOTP = document.getElementById('resendOTP');
        const resendText = document.getElementById('resendText');
        const countdownText = document.getElementById('countdownText');
        const countdownTimer = document.getElementById('countdownTimer');

        //on submit form make all input readonly and disable submit button
        form.addEventListener('submit', (e) => {
            // e.preventDefault();
            inputs.forEach((input) => {
                input.readOnly = true;

            });
            document.getElementById("submitForm").disabled = true;
            document.getElementById("submitForm").innerHTML = "Loading...";
            resendOTP.disabled = true;
        });

        document.getElementById("resendOtpForm").addEventListener('submit', (e) => {
            // e.preventDefault();
            inputs.forEach((input) => {
                input.readOnly = true;

            });
            document.getElementById("submitForm").disabled = true;
            resendOTP.disabled = true;
            resendOTP.innerHTML = "Loading...";
        });


        let countdownInterval;
        const countdownDuration = 300;

        // Function to distribute pasted OTP across input fields
        function handlePaste(e) {
            e.preventDefault();
            const pastedText = e.clipboardData.getData('text').replace(/\D/g, '').slice(0, 6);
            inputs.forEach((input, index) => {
                if (index < pastedText.length) {
                    input.value = pastedText[index];
                } else {
                    input.value = '';
                }
            });
            if (pastedText.length === 6) {
                inputs[5].focus();
            } else {
                inputs[pastedText.length].focus();
            }
        }

        // Add paste event listener to each input
        inputs.forEach(input => {
            input.addEventListener('paste', handlePaste);
        });

        // Auto-focus next input and handle backspace
        inputs.forEach((input, index) => {
            input.addEventListener('input', function() {
                if (this.value.length === this.maxLength) {
                    if (index < inputs.length - 1) {
                        inputs[index + 1].focus();
                    }
                }
            });

            input.addEventListener('keydown', function(e) {
                if (e.key === 'Backspace' && !this.value) {
                    if (index > 0) {
                        inputs[index - 1].focus();
                    }
                }
            });
        });

        function startCountdown() {
            let timeLeft = countdownDuration;
            resendText.classList.add('hidden');
            countdownText.classList.remove('hidden');

            countdownInterval = setInterval(() => {
                if (timeLeft <= 0) {
                    clearInterval(countdownInterval);
                    resendText.classList.remove('hidden');
                    countdownText.classList.add('hidden');
                    resendOTP.classList.remove('pointer-events-none', 'opacity-50');
                } else {
                    countdownTimer.textContent = timeLeft;
                    timeLeft--;
                }
            }, 1000);
        }

        startCountdown();
    </script>
</body>

</html>
