<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\DB;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'nik',
        'nama',
        'email',
        'password',
        'role',
        'no_telp',
        'no_wa',
        'provinsi_id',
        'kabupaten_kota_id',
        'kecamatan_id',
        'kelurahan_desa_id',
        'tps_id',
        'dps_id',
        'dpt_id',
        'status',
        'partai_id',
        'device_token'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];

    public function dpt(){
        return $this->belongsTo(Dpt::class)->withDefault([
            'nama'=>'Tidak Ada'
        ]);
    }

    public function tps(){
        return $this->belongsTo(Tps::class)->withDefault([
            'nomor'=>'Tidak Ada',
            'kelurahan_desa'=>[
                'nama'=>'Tidak Ada'
            ]
        ]);
    }

    public function kelurahan_desa(){
        return $this->belongsTo(KelurahanDesa::class)->withDefault([
            'nama'=>'Tidak Ada'
        ]);
    }

    public function kecamatan(){
        return $this->belongsTo(Kecamatan::class)->withDefault([
            'nama'=>'Tidak Ada'
        ]);
    }

    public function kabupaten_kota(){
        return $this->belongsTo(KabupatenKota::class)->withDefault([
            'nama'=>'Tidak Ada'
        ]);
    }

    public function provinsi(){
        return $this->belongsTo(Provinsi::class)->withDefault([
            'nama'=>'Tidak Ada'
        ]);
    }

    public function suara(){
        return $this->hasOne(Suara::class);
    }

    public function getStatusColorAttribute(){
        $color = "green";
        switch ($this->status) {
            case 'tidak sesuai':
                // $color = "red";
                $color = "greeb";
                break;
            case 'sudah ada':
                $color = "yellow";
                break;
            default:
                # code...
                break;
        }

        return $color;
    }

    public function partai(){
        return $this->belongsTo(Partai::class)->withDefault([
            'nama'=>'Tidak Ada'
        ]);
    }

    public function multi_tps(){
        return $this->morphToMany(Tps::class,'tpsable');
    }

    public function suaras()
    {
        return $this->morphedByMany(Suara::class, 'userable');
    }
}
