<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tps extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'id',
        'nomor',
        'rt_rw',
        'alamat',
        'kelurahan_desa_id'
    ];

    public function kelurahan_desas(){
        return $this->morphToMany(KelurahanDesa::class, 'kelurahan_desaables', 'kelurahan_desaables','kelurahan_desaables_id','kelurahan_desa_id');
    }

    public function kelurahan_desa(){
        return $this->belongsTo(KelurahanDesa::class)->withDefault([
            'nama'=>'Tidak Ada'
        ]);
    }

    public function dpt(){
        return $this->hasMany(Dpt::class);
    }

    public function suaras(){
        return $this->hasMany(Suara::class);
    }

    public function saksis(){
        return $this->hasMany(User::class,'tps_id')->where('role','saksi');
    }

    public function users(){
        return $this->hasMany(User::class,'tps_id');
    }
}
