<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class Suara extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable = [
        'user_id',
        'tps_id',
        'tanggal',
        'total_suara',
        'suara_sah',
        'suara_tidak_sah',
        'jumlah_dpt',
        'jumlah_hak_pilih',
        'jumlah_surat_suara_digunakan',
        'status',
        'bermasalah_paslon',
        'bermasalah_hak_pilih',
        'menang'
    ];

    public function user(){
        return $this->belongsTo(User::class)->withDefault([
            'nama'=>'tidak ditemukan/dihapus'
        ]);
    }

    public function tps(){
        return $this->belongsTo(Tps::class);
    }

    public function suara_details(){
        return $this->hasMany(SuaraDetail::class);
    }

    public function file_lampirans(){
        return $this->hasMany(FileLampiran::class)->orderBy('nama','ASC');
    }

    public function getStatusPaslonSahLabelAttribute(){

        $status = "TIDAK BERMASALAH";
        if($this->suara_details->sum('jumlah_suara') != $this->suara_sah){
            $status = "BERMASALAH"; 
        }
        return $status;
    }

    public function getStatusHakPilihSahTidakSahLabelAttribute(){

        $status = "TIDAK BERMASALAH";
        if($this->jumlah_hak_pilih != ($this->suara_sah+$this->suara_tidak_sah)){
            $status = "BERMASALAH"; 
        }
        return $status;
    }

    public function getStatusLabelAttribute(){
        $status = "KALAH";
        if($this->menang){
            $status = "MENANG";
        } else {
            $status = "KALAH";
        }

        if($this->bermasalah_hak_pilih){
            $status .= " BERMASALAH"; 
        } else {
            $status .= " TIDAK BERMASALAH";
        }
        return $status;
    }

    public function getStatusMenangKalahLabelAttribute(){
        $status = "KALAH";
        if($this->menang){
            $status = "MENANG";
        } else {
            $status = "KALAH";
        }

        return $status;
    }

    public function multi_user(){
        return $this->morphToMany(User::class,'userable');
    }
}
