<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pengumuman extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'judul',
        'isi',
        'pertanyaan',
        'provinsi_id',
        'kabupaten_kota_id',
        'kecamatan_id',
        'kelurahan_desa_id',
        'user_saksi_id',
        'partai_id',
        'aktif'
    ];

    public function user(){
        return $this->belongsTo(User::class);
    }

    public function partai(){
        return $this->belongsTo(Partai::class);
    }

    public function user_saksi(){
        return $this->belongsTo(User::class,'user_saksi_id');
    }

    public function pengumuman_jawabs(){
        return $this->hasMany(PengumumanJawab::class);
    }

    public function kelurahan_desa(){
        return $this->belongsTo(KelurahanDesa::class);
    }

    public function kecamatan(){
        return $this->belongsTo(Kecamatan::class);
    }

    public function kabupaten_kota(){
        return $this->belongsTo(KabupatenKota::class);
    }

    public function provinsi(){
        return $this->belongsTo(Provinsi::class)->withDefault([
            'nama'=>'Tidak Ada'
        ]);
    }
}
