<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Str;

class Kecamatan extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'nama',
        'kabupaten_kota_id'
    ];

    public function kabupaten_kota()
    {
        return $this->belongsTo(KabupatenKota::class)->withDefault([
            'nama'=>'Tidak Ada'
        ]);
    }

    public function kelurahan_desas()
    {
        return $this->hasMany(KelurahanDesa::class);
    }

    public function users(){
        return $this->hasMany(User::class);
    }

    public function getNamaSlugAttribute(){
        return Str::slug($this->nama);
    }

    public function koordinators(){
        return $this->hasMany(User::class,'kecamatan_id')->where('role','koordinator-kecamatan');
    }
}
