<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Calon extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'nomor',
        'nama_calon',
        'nama_wakil_calon',
        'foto_pasangan',
        'foto_calon',
        'foto_wakil_calon'
    ];

    public function suara_details(){
        return $this->hasMany(SuaraDetail::class);
    }

    public function getSuaraAttribute(){
        return $this->suara_details->sum('jumlah_suara');
    }
}
