<?php

namespace App\Imports;

use App\Models\Dpt;
use App\Models\KabupatenKota;
use App\Models\Kecamatan;
use App\Models\KelurahanDesa;
use App\Models\Provinsi;
use App\Models\Partai;
use App\Models\Tps;
use App\Models\User;
use Exception;
use Maatwebsite\Excel\Concerns\ToModel;

class UsersImport implements ToModel
{   
    public $users = [];
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {   
        if($row[0] == "NIK" || $row[1] == ""|| !isset($row[2]) ||$row[2] == "" || count($row) < 10 || !isset($row[3])){
            return null;
        }
        $provinsi = Provinsi::where('nama',$row[5])->first();
        if(!$provinsi){
            throw new Exception("Provinsi Not Found : ".$row[5]);
            
        }

        $kabupatenKota = KabupatenKota::where('nama',$row[6])->first();
        if(!$kabupatenKota && $row[3] != "koordinator-provinsi"){
            throw new Exception("Kabupaten/Kota Not Found : ".$row[6]);
        }

        $kecamatan = Kecamatan::where('nama',$row[7])->where('kabupaten_kota_id',@$kabupatenKota->id)->first();
        if(!$kecamatan && $row[3] != "koordinator-provinsi" && $row[3] != "koordinator-kabupaten-kota"){
            throw new Exception("Kecamatan Not Found : ".$row[7]);
        }

        $kelurahanDesa = KelurahanDesa::where('nama',$row[8])->where('kecamatan_id',@$kecamatan->id)->first();
        if(!$kelurahanDesa && $row[3] != "koordinator-provinsi" && $row[3] != "koordinator-kabupaten-kota" && $row[3] != "koordinator-kabupaten-kota" && $row[3] != "koordinator-kecamatan"){
            throw new Exception("Kelurahan/Desa Not Found : ".$row[8]);
        }

        $tps = Tps::where('nomor',(int)$row[10])->where('kelurahan_desa_id',@$kelurahanDesa->id)->first();
        if(!$tps && $row[3] != "koordinator-provinsi" && $row[3] != "koordinator-kabupaten-kota" && $row[3] != "koordinator-kabupaten-kota" && $row[3] != "koordinator-kecamatan" && $row[3] != "koordinator-kelurahan-desa"){
            throw new Exception("TPS Not Found : ".$row[10]);
        }

        $cekNoHp = User::where('no_wa',str_replace("'","",$row[2]))->first();
        if($cekNoHp){
            throw new Exception("No Wa : ".str_replace("'","",$row[2])." sudah terdaftar");
        }

        $partai_id = null;
        if(isset($row[11])){
            $partai_id = @Partai::where('nama',$row[1])->first()->id;
        }
        $status = "sesuai";
        $dpt_id = null;
        if(strtolower($row[3]) == "saksi"){
            $cekDpt = Dpt::where(function($w)use($row){
                $w->where(function($w)use($row){
                    $w->where('nik',$row[0])->where('nik','!=','')->where('nik','!=',null);
                })->orWhere('nama',$row[1]);
            })->where('tps_id',$tps->id)->first();
            if(!$cekDpt){
                $status = "tidak sesuai";
            } else {
                $dpt_id = $cekDpt->dpt_id;
                $cekUser = User::where('dpt_id', $cekDpt->dpt_id)
                ->where('role','saksi')
                ->where('tps_id', $tps->id)->first();
                if ($cekUser) {
                    $status = "sudah ada";
                }
                $cekUser = User::whereHas('suaras',function($w)use($tps){
                    $w->where('tps_id',$tps->id);
                })->where('role','saksi')->count();
                if($cekUser >= 2){
                    $status = "sudah ada";
                }
            }
        }

        if(str_contains(strtolower($row[3]),"koordinator")){
            $cekDpt = Dpt::where(function($w)use($row){
                $w->where(function($w)use($row){
                    $w->where('nik',$row[0])->where('nik','!=','')->where('nik','!=',null);
                })->orWhere('nama',$row[1]);
            })->where('tps_id',$tps->id)->first();
            if(!$cekDpt){
                $status = "tidak sesuai";
            } else {
                $dpt_id = $cekDpt->dpt_id;
                $cekUser = User::where(function($w)use($row){
                    $w->where(function($w)use($row){
                        $w->where('nik',$row[0])->where('nik','!=','')->where('nik','!=',null);
                    })->orWhere('nama',$row[1]);
                })->whereIn('role',['koordinator-kabupaten-kota','koordinator-kecamatan','koordinator-kelurahan-desa'])->where('tps_id',$tps->id)->first();
                if($cekUser){
                    $status = "sudah ada";
                }
            }
        }
        $no_wa = str_replace("'","",$row[2]);
        //remove all symbol and alphabet from $no_wa
        $no_wa = preg_replace('/[^\p{L}\p{N}\s]/u', '', $no_wa);

        //check if first character not 0
        if(mb_substr($no_wa, 0, 1) != '0'){
            $no_wa = '0'.$no_wa;
        }
        
        $password = substr(str_shuffle('0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'), 1, 8);
        $newUser = new User([
            'nik'=>$row[0],
            'nama'=>$row[1],
            'no_wa'=>$no_wa,
            'no_telp'=>$no_wa,
            'password'=>bcrypt($password),
            'role'=>strtolower($row[3]),
            'email'=>$row[4],
            'provinsi_id'=>@$provinsi->id,
            'kabupaten_kota_id'=>@$kabupatenKota->id,
            'kecamatan_id'=>@$kecamatan->id,
            'kelurahan_desa_id'=>@$kelurahanDesa->id,
            'tps_id'=>@$tps->id,
            'dpt_id'=>$dpt_id,
            'status'=>$status,
            'partai_id'=>$partai_id
        ]);
        $this->users[] = [
            'nama'=>$row[1],
            'no_wa'=>str_replace("'","",$row[2]),
            'no_telp'=>str_replace("'","",$row[2]),
            'password'=>$password
        ];
        
        return $newUser;
    }
}
