<?php

namespace App\Imports;

use App\Models\Dpt;
use App\Models\KabupatenKota;
use App\Models\Kecamatan;
use App\Models\KelurahanDesa;
use App\Models\Provinsi;
use App\Models\Partai;
use App\Models\Tps;
use App\Models\User;
use Exception;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithCalculatedFormulas;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;

class UserKoordinatorsImport implements ToModel, WithMultipleSheets, WithCalculatedFormulas
{
    public $users = [];
    public $errors = [];

    public function sheets(): array
    {
        return [
            0 => $this,
        ];
    }

    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        if (strtolower($row[0]) == "nik" || !isset($row[5]) || $row[5] == "") {
            return null;
        }
        try {
            $provinsi = Provinsi::where('nama', $row[4])->first();
            if (!$provinsi) {
                throw new Exception("Provinsi Not Found : " . $row[4]);

            }

            $kabupatenKota = KabupatenKota::where('nama', $row[5])->first();
            if (!$kabupatenKota) {
                throw new Exception("Kabupaten/Kota Not Found : " . $row[5]);
            }

            $kecamatan = Kecamatan::where('nama', $row[6])->first();
            if (!$kecamatan && request()->koordinator == "kecamatan") {
                throw new Exception("Kecamatan Not Found : " . $row[6]);
            }

            $kelurahanDesa = KelurahanDesa::where('nama', $row[7])->first();
            if (!$kelurahanDesa && request()->koordinator == "kelurahan-desa") {
                throw new Exception("Kelurahan/Desa Not Found : " . $row[7]);
            }

            // $tps = Tps::where('nomor',(int)$row[9])->whereHas('kelurahan_desas',function($wd)use($kelurahanDesa){
            //     $wd->where('kelurahan_desaables.kelurahan_desa_id',$kelurahanDesa->id);
            // })->first();
            $tps = Tps::where('nomor', (int) $row[8])->where('kelurahan_desa_id', @$kelurahanDesa->id)->first();
            // if(!$tps){
            //     throw new Exception("TPS Not Found : ".$row[8]);
            // }

            $no_wa = str_replace("'", "", $row[2]);
            //remove all symbol and alphabet from $no_wa
            $no_wa = preg_replace('/[^\p{L}\p{N}\s]/u', '', $no_wa);
            //check if first character is 62
            if (substr($no_wa, 0, 2) === '62') {
                $no_wa = '0' . substr($no_wa, 2);
            }

            //check if first character not 0
            if (mb_substr($no_wa, 0, 1) != '0') {
                $no_wa = '0' . $no_wa;
            }

            $cekNoHp = User::where('no_wa', $no_wa)->first();
            if ($cekNoHp) {
                throw new Exception("No WA : " . str_replace("'", "", $row[2]) . " sudah terdaftar atas nama  : " . $cekNoHp->nama . " | " . $cekNoHp->role);
            }
            $partai_id = null;
            if (isset($row[11])) {
                $partai_id = @Partai::where('nama', str_replace("PARTAI", "", $row[9]))->first()->id;
            }
            $multi_tps_id = [];
            if (isset($row[10])) {
                $tps_nomors = explode(";", (string) $row[10]);
                $tps_nomors = array_unique($tps_nomors);
                foreach ($tps_nomors as $nomor) {
                    $cek = Tps::where('nomor', (int) $nomor)->where('kelurahan_desa_id', @$kelurahanDesa->id)->first();
                    if (!$cek) {
                        throw new Exception("TPS Not Found : " . (int) $nomor);
                    } else {
                        $multi_tps_id[] = $cek->id;
                    }
                }
            }
            $status = "sesuai";
            if ($tps) {
                $cekDpt = Dpt::where(function ($w) use ($row) {
                    $w->where(function ($w) use ($row) {
                        $w->where('nik', $row[0])->where('nik', '!=', '')->where('nik', '!=', null);
                    })->orWhere('nama', $row[1]);
                })->where('tps_id', @$tps->id)->first();
                if (!$cekDpt) {
                    $status = "tidak sesuai";
                } else {
                    $cekUser = User::where(function ($w) use ($row) {
                        $w->where(function ($w) use ($row) {
                            $w->where('nik', $row[0])->where('nik', '!=', '')->where('nik', '!=', null);
                        })->orWhere('nama', $row[1]);
                    })->whereIn('role', ['koordinator-kabupaten-kota', 'koordinator-kecamatan', 'koordinator-kelurahan-desa'])->where('tps_id', @$tps->id)->first();
                    if ($cekUser) {
                        $status = "sudah ada";
                    }
                }
            } else {
                $status = "tidak sesuai";
            }

            $password = substr(str_shuffle('0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'), 1, 8);

            $newUser = new User([
                'nik' => preg_replace('/[^\p{L}\p{N}\s]/u', '', $row[0]),
                'nama' => $row[1],
                'no_wa' => $no_wa,
                'no_telp' => $no_wa,
                'password' => bcrypt($password),
                'email' => $row[3],
                'role' => 'koordinator-' . request()->koordinator,
                'provinsi_id' => $provinsi->id,
                'kabupaten_kota_id' => @$kabupatenKota->id,
                'kecamatan_id' => @$kecamatan->id,
                'kelurahan_desa_id' => @$kelurahanDesa->id,
                'tps_id' => @$tps->id,
                'status' => $status,
                'dpt_id' => @$cekDpt->id,
                'partai_id' => $partai_id
            ]);

            if (request()->koordinator == "kelurahan-desa") {
                $newUser->save();
                $newUser->multi_tps()->attach($multi_tps_id);
            }

            $this->users[] = [
                'nik' => $newUser->nik,
                'nama' => $newUser->nama,
                'no_telp' => $newUser->no_telp,
                'no_wa' => $newUser->no_wa,
                'password' => $password,
                'partai_id'=>$newUser->partai_id,
                'kabupaten_kota_id'=>@$kabupatenKota->id,
                'kabupaten_kota'=>@$kabupatenKota->nama == "Tidak Ada" ? null : @$kabupatenKota->nama,
                'kecamatan_id'=>@$kecamatan->id,
                'kecamatan'=>@$kecamatan->nama == "Tidak Ada" ? null : @$kecamatan->nama,
                'kelurahan_desa_id'=>@$kelurahanDesa->id,
                'kelurahan_desa'=>@$kelurahanDesa->nama == "Tidak Ada" ? null : @$kelurahanDesa->nama,            ];
            return $newUser;
        } catch (\Throwable $th) {
            $this->errors[] = "Error : ".$th->getMessage();
            return null;
        }
    }
}
