<?php

namespace App\Imports;

use App\Models\KabupatenKota;
use App\Models\Kecamatan;
use App\Models\KelurahanDesa;
use App\Models\Provinsi;
use App\Models\Suara;
use App\Models\Tps;
use Exception;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithCalculatedFormulas;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;

class SuarasImport implements ToModel, WithMultipleSheets, WithCalculatedFormulas
{   
    
    public $calons = [];

    public function sheets(): array
    {
        return [
            0 => $this,
        ];
    }

    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {   

        if(trim($row[0]) == "" || str_contains(strtolower($row[0]),"paslon")){
            return null;
        }
        $provinsi = Provinsi::where('nama', $row[2])->first();
        if (!$provinsi) {
            throw new Exception("Provinsi Not Found : " . $row[2]);

        }

        $kabupatenKota = KabupatenKota::where('nama', $row[3])->first();
        if (!$kabupatenKota) {
            throw new Exception("Kabupaten/Kota Not Found : " . $row[3]);
        }

        $kecamatan = Kecamatan::where('nama', $row[4])->first();
        if (!$kecamatan) {
            throw new Exception("Kecamatan Not Found : " . $row[4]);
        }

        $kelurahanDesa = KelurahanDesa::where('nama', $row[5])->first();
        if (!$kelurahanDesa) {
            throw new Exception("Kelurahan/Desa Not Found : " . $row[5]);
        }

        $tps = Tps::where('nomor', (int) $row[6])->where('kelurahan_desa_id', $kelurahanDesa->id)->first();
        if (!$tps) {
            throw new Exception("TPS Not Found : " . $row[6]);
        }
        $user = auth()->user();
        $suara = Suara::updateOrCreate([
            'tps_id' => $tps->id,
            'status' => 'approve',

        ],[
            'user_id' => $user->id,
            'tanggal' => date("Y-m-d"),
            'total_suara' => ((int)$row[0]) + ((int)$row[1]),
            'suara_tidak_sah' => 0,
            'suara_sah' => 0,
            'jumlah_dpt' => 0,
            'jumlah_hak_pilih' => 0,
            'jumlah_surat_suara_digunakan' => 0,
            'status' => 'approve',
        ]);

        foreach ($this->calons as $key => $calon) {
            $suara->suara_details()->updateOrCreate([
                'calon_id' => $calon->id
            ], [
                'jumlah_suara' => (int)$row[$key]
            ]);
        }
        
    }
}
