<?php

namespace App\Imports;

use App\Models\Dps;
use App\Models\KabupatenKota;
use App\Models\Kecamatan;
use App\Models\KelurahanDesa;
use App\Models\Tps;
use Maatwebsite\Excel\Concerns\ToModel;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;

class DpsImport implements ToCollection
{   

    private function normalizeKota($kota){
        $kota = strtolower($kota);
        $newKota = strtoupper($kota);
        switch ($kota) {
            case 'balikpapan':
                $newKota = "KOTA BALIKPAPAN";
                break;
            case 'samarinda':
                $newKota = "KOTA SAMARINDA";
                break;
            case 'bontang':
                $newKota = "KOTA BONTANG";
                break;
            case 'ppu':
                $newKota = "KAB. PENAJAM PASER UTARA";
                break;
            case 'paser':
                $newKota = "KAB. PASER";
                break;
            case 'kukar':
                $newKota = "KAB. KUTAI KARTANEGARA";
                break;
            case 'kubar':
                $newKota = "KAB. KUTAI BARAT";
                break;
            case 'kutim':
                $newKota = "KAB. KUTAI TIMUR";
                break;
            case 'berau':
                $newKota = "KAB. BERAU";
                break;
            case 'mahulu':
                $newKota = "KAB. MAHAKAM ULU";
                break;
            default:
                # code...
                break;
        }
        return $newKota;
    }

    public function collection(Collection $rows)
    {
        foreach ($rows as $row) 
        {
            if(strtolower($row[0]) == 'no' && !isset($row[9]) && ($row[9] == '' || $row[9] == null) || !isset($row[2]) || $row[2] == null){
                continue;
            }
            $kabKota = KabupatenKota::where('nama',$this->normalizeKota($row[12]))->first();
            if(!$kabKota){
                continue;
            }
            $kecamatan = Kecamatan::where('nama',$row[11])->where('kabupaten_kota_id',$kabKota->id)->first();
            if(!$kecamatan){
                $kecamatan = Kecamatan::create([
                    'nama'=>$row[11],
                    'kabupaten_kota_id'=>$kabKota->id,
                ]);
            }
            $kelurahanDesa = $kecamatan->kelurahan_desas()->where('nama',$row[10])->first();
            if(!$kelurahanDesa){
                $kelurahanDesa = KelurahanDesa::create([
                    'nama'=>$row[10],
                    'kecamatan_id'=>$kecamatan->id,
                ]);
            }
            $tps = Tps::where('nomor',$row[9])->where('kelurahan_desa_id',$kelurahanDesa->id)->first();
            if(!$tps){
                $tps = Tps::create([
                    'nomor'=>$row[9],
                    'rt_rw'=>$row[4].'/'.$row[5],
                    'alamat'=>$row[8],
                    'kelurahan_desa_id' => $kelurahanDesa->id
                ]);
                //$tps->kelurahan_desas()->attach($kelurahanDesa->id);
            }
            Dps::firstOrCreate([
                'nama'=>$row[1],
                'jenis_kelamin'=>$row[2],
                'usia'=>$row[3],
                'rt'=>strlen($row[4]) > 3 ? "000" : $row[4],
                'rw'=>strlen($row[5]) > 3 ? "000" : $row[5],
                'nik'=>$row[6],
                'ket' => $row[7],
                'alamat'=>$row[8],
                'tps_id'=>$tps->id,
            ]);
        }
    }

    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {   
        
    }
}
