<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Cache\RateLimiter;
use Symfony\Component\HttpFoundation\Response;

class VerifikasiOtpMiddleware
{
    protected $limiter;

    public function __construct(RateLimiter $limiter)
    {
        $this->limiter = $limiter;
    }

    public function handle($request, Closure $next, $maxAttempts = 4, $decayMinutes = 1)
    {
        $key = $request->ip(); // You can customize the key based on your needs

        if ($this->limiter->tooManyAttempts($key, $maxAttempts)) {
            return response('Ops kamu terlalu banyak melakukan percobaan login, silahkan tunggu beberapa saat lagi', Response::HTTP_TOO_MANY_REQUESTS);
        }

        $this->limiter->hit($key, $decayMinutes * 60);

        $response = $next($request);

        return $response;
    }
}
