<?php

namespace App\Http\Controllers;

use App\DataTables\TpsDataTable;
use App\Exports\TpssExport;
use App\Helpers\Helper;
use App\Models\Tps;
use App\Models\KelurahanDesa;
use App\Models\Provinsi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Facades\Excel;

class TpsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    // public function index()
    // {   
    //     $q = request()->query('q');
    //     $datas = Tps::with('kelurahan_desa.kecamatan.kabupaten_kota')
    //     ->where(function($w)use($q){
    //         $w->where('nomor','like','%'.$q.'%')->orWhereHas('kelurahan_desas',function($ww)use($q){
    //             $ww->where('nama','like','%'.$q.'%');
    //         });
    //     });
    //     if(request()->kelurahan_desa_id){
    //         $datas = $datas->where('kelurahan_desa_id',request()->kelurahan_desa_id);
    //     } else if(request()->kecamatan_id){
    //         $datas = $datas->whereHas('kelurahan_desa',function($w){
    //             $w->where('kecamatan_id',request()->kecamatan_id);
    //         });
    //     } else if(request()->kabupaten_kota_id){
    //         $datas = $datas->whereHas('kelurahan_desa',function($w){
    //             $w->whereHas('kecamatan',function($w){
    //                 $w->where('kabupaten_kota_id',request()->kabupaten_kota_id);
    //             });
    //         });
    //     } else if(request()->provinsi_id){
    //         $datas = $datas->whereHas('kelurahan_desa',function($w){
    //             $w->whereHas('kecamatan',function($w){
    //                 $w->whereHas('kabupaten_kota',function($w){
    //                     $w->where('provinsi_id',request()->provinsi_id);
    //                 });
    //             });
    //         });
    //     }
    //     $datas = $datas->paginate(10)->appends(['q'=>$q]);
    //     $provinsis = Provinsi::all();
    //     return view('tps.index',compact('datas','q','provinsis'));
    // }

    public function index(TpsDataTable $dataTable)
    {
        if (request()->export) {
            $exportClass = new TpssExport;
            return Excel::download($exportClass, 'data_tps_' . date("YmdHis") . '.xlsx');
        }
        $provinsis = Provinsi::all();
        return $dataTable->render('tps.index', compact('provinsis'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        if (auth()->user()->role !== "admin") {
            return abort(404);
        }
        $kelurahanDesas = KelurahanDesa::all();
        return view('tps.create', compact('kelurahanDesas'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {   
        if (auth()->user()->role !== "admin") {
            return abort(404);
        }
        $request->validate([
            'nomor' => 'required',
            'kelurahan_desa_id' => 'required|exists:kelurahan_desas,id'
        ]);

        DB::beginTransaction();
        try {
            $tps = Tps::create($request->all());
            // $tps->kelurahan_desas()->attach($request->kelurahan_desa_id);
            DB::commit();
            Helper::addUserLog("Menambah data tps " . $tps->nomor);
            return redirect()->route('master-data.tps.index')->with('success', 'Data berhasil disimpan');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.tps.index')->with('error', 'Data gagal disimpan');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Tps $tps)
    {
        return view('tps.show', compact('tps'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {   
        if (auth()->user()->role !== "admin") {
            return abort(404);
        }
        $tps = Tps::findOrFail($id);
        $kelurahanDesas = KelurahanDesa::all();
        return view('tps.edit', ['data' => $tps, 'kelurahanDesas' => $kelurahanDesas]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {   
        if (auth()->user()->role !== "admin") {
            return abort(404);
        }
        $tps = Tps::findOrFail($id);
        $request->validate([
            'nomor' => 'required',
            'kelurahan_desa_id' => 'required|exists:kelurahan_desas,id'
        ]);

        DB::beginTransaction();
        try {
            $tps->update($request->all());
            DB::commit();
            Helper::addUserLog("Mengubah data tps " . $tps->nomor);
            return redirect()->route('master-data.tps.index')->with('success', 'Data berhasil diubah');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.tps.index')->with('error', 'Data gagal diubah');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {   
        if (auth()->user()->role !== "admin") {
            return abort(404);
        }
        $tps = Tps::findOrFail($id);
        if ($tps->dpt()->count() > 0) {
            return redirect()->back()->with('warning', 'Data tidak bisa dihapus, data ini masih dipakai di data lain');
        }
        DB::beginTransaction();
        try {
            $tps->delete();
            DB::commit();
            Helper::addUserLog("Menghapus data tps " . $tps->nomor);
            return redirect()->route('master-data.tps.index')->with('success', 'Data berhasil dihapus');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.tps.index')->with('error', 'Data gagal dihapus');
        }
    }
}
