<?php

namespace App\Http\Controllers;

use App\DataTables\SuarasDataTable;
use App\Exports\FormatImportSuaraExport;
use App\Exports\SuarasExport;
use App\Helpers\Helper;
use App\Imports\SuarasImport;
use App\Models\Calon;
use App\Models\FileLampiran;
use App\Models\Partai;
use App\Models\Provinsi;
use App\Models\Suara;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Laravel\Facades\Image;
use Maatwebsite\Excel\Facades\Excel;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Imagick\Driver;
use ZipArchive;

use Illuminate\Support\Facades\Http;

class SuaraController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    // public function index()
    // {   
    //     $q = request()->query('q');
    //     $datas = Suara::with('tps.kelurahan_desa.kecamatan.kabupaten_kota','user','multi_user')
    //     ->with(['tps'=>function($w){
    //         $w->withCount('dpt');
    //     }])
    //     ->with(['suara_details'=>function($w){
    //         $w->orderBy('calon_id','asc');
    //     }]);
    //     if(auth()->user()->role == "koordinator-kelurahan-desa"){
    //         $datas = $datas->whereHas('tps',function($w){
    //             $w->where('kelurahan_desa_id',auth()->user()->kelurahan_desa_id);
    //         });
    //     }

    //     if(auth()->user()->role == "koordinator-kecamatan"){
    //         $datas = $datas->whereHas('tps.kelurahan_desa',function($w){
    //             $w->where('kecamatan_id',auth()->user()->kecamatan_id);
    //         });
    //     }

    //     if(auth()->user()->role == "koordinator-kabupaten-kota"){
    //         $datas = $datas->whereHas('tps.kelurahan_desa.kecamatan',function($w){
    //             $w->where('kabupaten_kota_id',auth()->user()->kabupaten_kota_id);
    //         });
    //     }
    //     if($q){
    //         $datas = $datas->whereHas('user',function($w)use($q){
    //             $w->where('nama','like','%'.$q.'%');
    //         });
    //     }
    //     if (request()->kelurahan_desa_id) {
    //         $datas = $datas->whereHas('tps',function($w){
    //             $w->where('kelurahan_desa_id', request()->kelurahan_desa_id);
    //         });
    //     } else if (request()->kecamatan_id) {
    //         $datas = $datas->whereHas('tps',function($w){
    //             $w->whereHas('kelurahan_desa', function ($w) {
    //                 $w->where('kecamatan_id', request()->kecamatan_id);
    //             });
    //         });
    //     } else if (request()->kabupaten_kota_id) {
    //         $datas = $datas->whereHas('tps',function($w){
    //             $w->whereHas('kelurahan_desa', function ($w) {
    //                 $w->whereHas('kecamatan', function ($w) {
    //                     $w->where('kabupaten_kota_id', request()->kabupaten_kota_id);
    //                 });
    //             });
    //         });
    //     } else if (request()->provinsi_id) {
    //         $datas = $datas->whereHas('tps',function($w){
    //             $w->whereHas('kelurahan_desa', function ($w) {
    //                 $w->whereHas('kecamatan', function ($w) {
    //                     $w->whereHas('kabupaten_kota', function ($w) {
    //                         $w->where('provinsi_id', request()->provinsi_id);
    //                     });
    //                 });
    //             });
    //         });
    //     }
    //     $datas = $datas->orderBy('created_at','DESC')->paginate(10)->appends(['q'=>$q]);
    //     $calons = Calon::orderBy('id','asc')->get();
    //     $provinsis = Provinsi::all();
    //     return view('suara.index',compact('datas','q','calons','provinsis'));
    // }

    public function index(SuarasDataTable $dataTable)
    {


        if (request()->export) {
            $exportClass = new SuarasExport(Calon::all());
            return Excel::download($exportClass, 'data_suara_' . date("YmdHis") . '.xlsx');
        }
        $provinsis = Provinsi::all();
        $partais = Partai::all();
        return $dataTable->render('suara.index', compact('provinsis', 'partais'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {

        $calons = Calon::orderBy('nomor', 'asc')->get()->map(function ($calon) {

            return [
                'id' => $calon->id,
                "name" => $calon->nomor . ' : ' . $calon->nama_calon . ' - ' . $calon->nama_wakil_calon,
                "votes" => 0
            ];
        })->toArray();
        $provinsis = Provinsi::all();
        return view('suara.create', ['calons' => $calons, 'provinsis' => $provinsis]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {   
        try {
            $user = Auth::user();
            $suara = Suara::with('multi_user', 'suara_details')->where('tps_id', $request->tps_id)->first();
            $baru = true;
            if (!$suara) {
                $suara = Suara::create([
                    'user_id' => $user->id,
                    'tps_id' => $request->tps_id,
                    'tanggal' => date("Y-m-d"),
                    'total_suara' => array_sum($request->jumlah_suara ?? []) + ($request->suara_tidak_sah ?? 0),
                    'suara_tidak_sah' => $request->suara_tidak_sah ?? 0,
                    'suara_sah' => $request->suara_sah ?? 0,
                    'jumlah_dpt' => 0,
                    'jumlah_hak_pilih' => 0,
                    'jumlah_surat_suara_digunakan' => 0,
                    'status' => 'approve',

                ]);
                $suara->multi_user()->detach();
            } else {
                tap($suara)->update([
                    'total_suara' => array_sum($request->jumlah_suara ?? []) + ($request->suara_tidak_sah ?? 0),
                    'suara_tidak_sah' => $request->suara_tidak_sah ?? 0,
                    'suara_sah' => $request->suara_sah ?? 0,
                    'jumlah_dpt' => 0,
                    'jumlah_hak_pilih' => 0,
                    'jumlah_surat_suara_digunakan' => 0,
                    'status' => 'approve',

                ]);
                $baru = false;
            }
            foreach ($request->jumlah_suara as $calon_id => $value) {
                $suara->suara_details()->updateOrCreate([
                    'calon_id' => $calon_id
                ], [
                    'jumlah_suara' => $value
                ]);
            }
            $request->validate([
                'file_1' => 'nullable|file',
                'file_2' => 'nullable|file',
                'file_3' => 'nullable|file',
            ]);
            if ($request->hasFile('file_1')) {
                $file = $request->file_1;
                $exte = strtolower($file->getClientOriginalExtension());
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 1 tidak sesuai');
                }
                $exte = strtolower(pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION));
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 1 tidak sesuai');
                }
                if (strpos(file_get_contents($file), '<?php') !== false) {
                    return redirect()->back()->with('error', 'Yakin ini file 1 gambar?');
                }
                $lembar1 = FileLampiran::updateOrCreate([
                    'suara_id' => $suara->id,
                    'nama' => 'lembar-1'
                ], [
                    'file' => $request->file('file_1')->storeAs($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                        $suara->tps->kelurahan_desa->nama . "/" .
                        $suara->tps->nomor, $this->formatFileName('lembar_1', $suara) . "." . $request->file('file_1')->extension())
                ]);
            }

            if ($request->hasFile('file_2')) {
                $file = $request->file_2;
                $exte = strtolower($file->getClientOriginalExtension());
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
                }
                $exte = strtolower(pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION));
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
                }
                if (strpos(file_get_contents($file), '<?php') !== false) {
                    return redirect()->back()->with('error', 'Yakin ini file 2 gambar?');
                }
                $lembar2 = FileLampiran::updateOrCreate([
                    'suara_id' => $suara->id,
                    'nama' => 'lembar-2'
                ], [
                    'file' => $request->file('file_2')->storeAs($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                        $suara->tps->kelurahan_desa->nama . "/" .
                        $suara->tps->nomor, $this->formatFileName('lembar_2', $suara) . "." . $request->file('file_2')->extension())
                ]);
            }

            if ($request->hasFile('file_3')) {
                $file = $request->file_3;
                $exte = strtolower($file->getClientOriginalExtension());
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 3 tidak sesuai');
                }
                $exte = strtolower(pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION));
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 3 tidak sesuai');
                }
                if (strpos(file_get_contents($file), '<?php') !== false) {
                    return redirect()->back()->with('error', 'Yakin ini file 3 gambar?');
                }
                $lembar3 = FileLampiran::updateOrCreate([
                    'suara_id' => $suara->id,
                    'nama' => 'lembar-3'
                ], [
                    'file' => $request->file('file_3')->storeAs($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                        $suara->tps->kelurahan_desa->nama . "/" .
                        $suara->tps->nomor, $this->formatFileName('lembar_3', $suara) . "." . $request->file('file_3')->extension())
                ]);
            }

            $targetDir = storage_path((strtoupper(substr(PHP_OS, 0, 3)) === 'WIN' ? "app\\": "app/").$suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
            $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
            $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
            $suara->tps->kelurahan_desa->nama . "/" .
            $suara->tps->nomor);
            if (!file_exists( $targetDir)) {
                mkdir($targetDir, 0755, true);
            }
            if($request->lembar_1_kpu){
                $file = $request->lembar_1_kpu;
                $exte = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
                }
                
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
                }
                if (strpos(file_get_contents($file), '<?php') !== false) {
                    return redirect()->back()->with('error', 'Yakin ini file 2 gambar?');
                }
                copy($file, $targetDir."/".$this->formatFileName('lembar_1', $suara).".".$exte);

                $lembar3 = FileLampiran::updateOrCreate([
                    'suara_id' => $suara->id,
                    'nama' => 'lembar-1'
                ], [
                    'file' => $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                    $suara->tps->kelurahan_desa->nama . "/" .
                    $suara->tps->nomor."/".$this->formatFileName('lembar_1', $suara).".".$exte
                ]);
            }

            if($request->lembar_2_kpu){
                $file = $request->lembar_2_kpu;
                $exte = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
                }
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
                }
                if (strpos(file_get_contents($file), '<?php') !== false) {
                    return redirect()->back()->with('error', 'Yakin ini file 2 gambar?');
                }
                copy($file, $targetDir."/".$this->formatFileName('lembar_2', $suara).".".$exte);

                $lembar3 = FileLampiran::updateOrCreate([
                    'suara_id' => $suara->id,
                    'nama' => 'lembar-2'
                ], [
                    'file' => $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                    $suara->tps->kelurahan_desa->nama . "/" .
                    $suara->tps->nomor."/".$this->formatFileName('lembar_2', $suara).".".$exte
                ]);
            }

            if($request->lembar_3_kpu){
                $file = $request->lembar_3_kpu;
                $exte = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
                }
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
                }
                if (strpos(file_get_contents($file), '<?php') !== false) {
                    return redirect()->back()->with('error', 'Yakin ini file 2 gambar?');
                }
                copy($file, $targetDir."/".$this->formatFileName('lembar_3', $suara).".".$exte);

                $lembar3 = FileLampiran::updateOrCreate([
                    'suara_id' => $suara->id,
                    'nama' => 'lembar-3'
                ], [
                    'file' => $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                    $suara->tps->kelurahan_desa->nama . "/" .
                    $suara->tps->nomor."/".$this->formatFileName('lembar_3', $suara).".".$exte
                ]);
            }
            Helper::addUserLog("Menyimpan suara manual untuk TPS : " . $suara->tps->nomor, json_encode($suara));
            if ($baru) {
                return redirect()->route('suara.index')->with('success', 'Suara untuk TPS : ' . $suara->tps->nomor . ' berhasil disimpan');
            } else {
                return redirect()->route('suara.index')->with('success', 'Suara untuk TPS : ' . $suara->tps->nomor . ' sebelumnya sudah diinput oleh saksi, berhasil menyimpan perubahan');
            }
        } catch (\Throwable $th) {
            //throw $th;
            Log::error($th);
            dd($th);
            return redirect()->back()->with('error', 'Suara gagal disimpan')->withInput($request->all());
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Suara $suara)
    {

        $calons = Calon::orderBy('nomor', 'ASC')->withSum([
            'suara_details' => function ($w) use ($suara) {
                $w->where('suara_id', $suara->id);
            }
        ], 'jumlah_suara')->get();
        return view('suara.show', ['suara' => $suara, 'calons' => $calons]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $suara = Suara::with('tps.kelurahan_desa.kecamatan.kabupaten_kota.provinsi')->findOrFail($id);
        $calons = Calon::orderBy('nomor', 'asc')->get()->map(function ($calon) use ($suara) {

            return [
                'id' => $calon->id,
                "name" => $calon->nomor . ' : ' . $calon->nama_calon . ' - ' . $calon->nama_wakil_calon,
                "votes" => (int) ($suara && $suara->suara_details->count() > 0 ? $suara->suara_details->where('calon_id', $calon->id)->first()->jumlah_suara : 0)
            ];
        })->toArray();

        $file1 = FileLampiran::where('suara_id', @$suara->id)->where('nama', 'lembar-1')->first();
        $file2 = FileLampiran::where('suara_id', @$suara->id)->where('nama', 'lembar-2')->first();
        $file3 = FileLampiran::where('suara_id', @$suara->id)->where('nama', 'lembar-3')->first();

        return view('suara.edit', ['suara' => $suara, 'calons' => $calons, 'file1' => $file1, 'file2' => $file2, 'file3' => $file3]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'file_1' => 'nullable|file',
            'file_2' => 'nullable|file',
            'file_3' => 'nullable|file',
        ]);
        $suara = Suara::with('suara_details')->findOrFail($id);
        DB::beginTransaction();
        try {
            // $bermasalah_paslon = array_sum($request->jumlah_suara) != $request->suara_sah;
            // $bermasalah_hak_pilih = $request->jumlah_hak_pilih != ($request->suara_sah + $request->suara_tidak_sah);
            tap($suara)->update([
                'total_suara' => array_sum($request->jumlah_suara ?? []) + $request->suara_tidak_sah,
                // 'suara_tidak_sah' => $request->suara_tidak_sah,
                // 'suara_sah' => $request->suara_sah,
                // 'jumlah_dpt' => $request->jumlah_dpt,
                // 'jumlah_hak_pilih' => $request->jumlah_hak_pilih,
                // 'bermasalah_paslon' => $bermasalah_paslon,
                // 'bermasalah_hak_pilih' => $bermasalah_hak_pilih,
                'status' => 'approve',
            ]);

            foreach ($request->jumlah_suara ?? [] as $calon_id => $value) {
                $suara->suara_details()->updateOrCreate([
                    'calon_id' => $calon_id
                ], [
                    'jumlah_suara' => $value
                ]);
            }

            if ($request->hasFile('file_1')) {
                $file = $request->file_1;
                $exte = strtolower($file->getClientOriginalExtension());
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 1 tidak sesuai');
                }
                $exte = strtolower(pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION));
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 1 tidak sesuai');
                }
                if (strpos(file_get_contents($file), '<?php') !== false) {
                    return redirect()->back()->with('error', 'Yakin ini file 1 gambar?');
                }
                $lembar1 = FileLampiran::updateOrCreate([
                    'suara_id' => $suara->id,
                    'nama' => 'lembar-1'
                ], [
                    'file' => $request->file('file_1')->storeAs($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                        $suara->tps->kelurahan_desa->nama . "/" .
                        $suara->tps->nomor, $this->formatFileName('lembar_1', $suara) . "." . $request->file('file_1')->extension())
                ]);
            }

            if ($request->hasFile('file_2')) {
                $file = $request->file_2;
                $exte = strtolower($file->getClientOriginalExtension());
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
                }
                $exte = strtolower(pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION));
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
                }
                if (strpos(file_get_contents($file), '<?php') !== false) {
                    return redirect()->back()->with('error', 'Yakin ini file 2 gambar?');
                }
                $lembar2 = FileLampiran::updateOrCreate([
                    'suara_id' => $suara->id,
                    'nama' => 'lembar-2'
                ], [
                    'file' => $request->file('file_2')->storeAs($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                        $suara->tps->kelurahan_desa->nama . "/" .
                        $suara->tps->nomor, $this->formatFileName('lembar_2', $suara) . "." . $request->file('file_2')->extension())
                ]);
            }

            if ($request->hasFile('file_3')) {
                $file = $request->file_3;
                $exte = strtolower($file->getClientOriginalExtension());
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 3 tidak sesuai');
                }
                $exte = strtolower(pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION));
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 3 tidak sesuai');
                }
                if (strpos(file_get_contents($file), '<?php') !== false) {
                    return redirect()->back()->with('error', 'Yakin ini file 3 gambar?');
                }
                $lembar3 = FileLampiran::updateOrCreate([
                    'suara_id' => $suara->id,
                    'nama' => 'lembar-3'
                ], [
                    'file' => $request->file('file_3')->storeAs($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                        $suara->tps->kelurahan_desa->nama . "/" .
                        $suara->tps->nomor, $this->formatFileName('lembar_3', $suara) . "." . $request->file('file_3')->extension())
                ]);
            }
            $targetDir = storage_path((strtoupper(substr(PHP_OS, 0, 3)) === 'WIN' ? "app\\": "app/").$suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
            $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
            $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
            $suara->tps->kelurahan_desa->nama . "/" .
            $suara->tps->nomor);
            if (!file_exists( $targetDir)) {
                mkdir($targetDir, 0755, true);
            }
            if($request->lembar_1_kpu){
                $file = $request->lembar_1_kpu;
                $exte = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
                }
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
                }
                if (strpos(file_get_contents($file), '<?php') !== false) {
                    return redirect()->back()->with('error', 'Yakin ini file 2 gambar?');
                }
                copy($file, $targetDir."/".$this->formatFileName('lembar_1', $suara).".".$exte);

                $lembar3 = FileLampiran::updateOrCreate([
                    'suara_id' => $suara->id,
                    'nama' => 'lembar-1'
                ], [
                    'file' => $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                    $suara->tps->kelurahan_desa->nama . "/" .
                    $suara->tps->nomor."/".$this->formatFileName('lembar_1', $suara).".".$exte
                ]);
            }

            if($request->lembar_2_kpu){
                $file = $request->lembar_2_kpu;
                $exte = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
                }
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
                }
                if (strpos(file_get_contents($file), '<?php') !== false) {
                    return redirect()->back()->with('error', 'Yakin ini file 2 gambar?');
                }
                copy($file, $targetDir."/".$this->formatFileName('lembar_2', $suara).".".$exte);

                $lembar3 = FileLampiran::updateOrCreate([
                    'suara_id' => $suara->id,
                    'nama' => 'lembar-2'
                ], [
                    'file' => $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                    $suara->tps->kelurahan_desa->nama . "/" .
                    $suara->tps->nomor."/".$this->formatFileName('lembar_2', $suara).".".$exte
                ]);
            }

            if($request->lembar_3_kpu){
                $file = $request->lembar_3_kpu;
                $exte = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
                }
                if (strpos($exte, 'php') !== false) {
                    return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
                }
                if (strpos(file_get_contents($file), '<?php') !== false) {
                    return redirect()->back()->with('error', 'Yakin ini file 2 gambar?');
                }
                copy($file, $targetDir."/".$this->formatFileName('lembar_3', $suara).".".$exte);

                $lembar3 = FileLampiran::updateOrCreate([
                    'suara_id' => $suara->id,
                    'nama' => 'lembar-3'
                ], [
                    'file' => $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                    $suara->tps->kelurahan_desa->nama . "/" .
                    $suara->tps->nomor."/".$this->formatFileName('lembar_3', $suara).".".$exte
                ]);
            }

            
            Helper::addUserLog("Mengubah data suara TPS " . $suara->tps->nomor, json_encode($suara));
            DB::commit();
            return redirect()->route('suara.index')->with('success', 'Suara TPS ' . $suara->tps->nomor . ' berhasil diubah');
        } catch (\Throwable $th) {
            DB::rollBack();
            //throw $th;
            Log::error($th);
            return redirect()->back()->with('error', 'Suara gagal diubah')->withInput($request->all());
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Suara $suara)
    {
        DB::beginTransaction();
        $lampirans = [];
        try {
            $lampirans = $suara->file_lampirans;
            $suara->multi_user()->detach();
            $suara->file_lampirans()->delete();
            $suara->suara_details()->delete();
            $suara->delete();
            Helper::addUserLog("Menghapus data suara TPS " . $suara->tps->nomor, json_encode($suara));
            DB::commit();
            foreach ($lampirans as $lampiran) {
                $path = $lampiran->file;
                if (Storage::exists($path)) {
                    Storage::delete($path);
                }
            }
            return redirect()->route('suara.index')->with('success', 'Suara berhasil dihapus');
        } catch (\Throwable $th) {
            DB::rollBack();
            //throw $th;
            Log::error($th);
            return redirect()->back()->with('error', 'Suara gagal dihapus');
        }
    }

    public function status($id, Request $request)
    {
        $suara = Suara::findOrFail($id);
        $suara->update([
            'status' => $request->status
        ]);
        return redirect()->route('suara.index')->with('success', 'Status berhasil diubah');

    }

    public function getFileLampiran($id)
    {
        $fileLampiran = FileLampiran::findOrFail($id);
        $path = $fileLampiran->file;

        if (Storage::exists($path)) {
            try {
                $mimeType = Storage::mimeType($path);
                $filename = basename($path);
                if (strpos($mimeType, 'php') !== false) {
                    return response()->json([
                        'error' => 'Format file tidak sesuai'
                    ]);
                }
                $exte = strtolower(pathinfo(storage_path("app/" . $path), PATHINFO_EXTENSION));
                if (strpos($exte, 'php') !== false) {
                    return response()->json([
                        'error' => 'Format file tidak sesuai'
                    ]);
                }
                if (strpos(file_get_contents(storage_path("app/" . $path)), '<?php') !== false) {
                    return response()->json([
                        'error' => 'Yakin ini file gambar?'
                    ]);
                }
                if (request()->size == "small") {
                    try {
                        try {
                            $manager = new ImageManager(
                                driver: Driver::class,
                                autoOrientation: config('image.options.autoOrientation', true),
                                decodeAnimation: config('image.options.decodeAnimation', true),
                                blendingColor: config('image.options.blendingColor', 'ffffff')
                            );
                            $img = $manager->read(storage_path("app/" . $path));

                        } catch (\Throwable $th) {
                            $img = Image::read(storage_path("app/" . $path));
                        }
                        // $img->resize(100, 100);
                        $img->scaleDown(width: 150);

                        return response($img->toJpeg(50), 200)
                            ->header('Content-Type', $mimeType)
                            ->header('Content-Disposition', 'inline; filename=' . '"' . $filename . '"')
                            ->header("Connection", "Keep-Alive");
                    } catch (\Throwable $th) {
                        //throw $th;
                    }

                }
                return response()->file(storage_path("app/" . $path), [
                    'Content-Type' => $mimeType,
                    'Content-Disposition' => 'inline; filename=' . '"' . $filename . '"',
                    "Connection" => "Keep-Alive",
                ]);
            } catch (\Throwable $th) {
                Log::info($path);
                Log::error($th);
                return abort(404);
            }
        } else {
            return abort(404);
        }

    }

    public function importView()
    {
        if (request()->export) {
            $exportClass = new FormatImportSuaraExport(auth()->user());
            return Excel::download($exportClass, 'format_import_suara_' . date("YmdHis") . '.xlsx');
        }

        return view('suara.import');
    }

    public function import(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:xlsx,xls'
        ]);

        $file = $request->file('file');
        DB::beginTransaction();
        try {
            $model = new SuarasImport;
            $model->calons = Calon::orderBy('nomor', 'asc')->get();
            $import = Excel::import($model, $file);
            DB::commit();
            Helper::addUserLog("Melakukan import data suara");
            return redirect()->route('suara.index')->with('success', 'Berhasil mengimport data suara');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->with('error', 'Data gagal diimport : ' . $th->getMessage());
        }
    }

    private function cleanString($str)
    {
        return str_replace(" ", "-", trim(str_replace("'", " ", str_replace(".", " ", $str))));
    }

    private function formatFileName($prefix, $suara)
    {
        return $prefix . "_"
            . $this->cleanString($suara->tps->nomor) . "_"
            . $this->cleanString($suara->tps->kelurahan_desa->nama) . "_"
            . $this->cleanString($suara->tps->kelurahan_desa->kecamatan->nama) . "_"
            . $this->cleanString($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama) . "_"
            . $this->cleanString($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama);
    }

    public function downloadSingleData($id)
    {
        // Ambil data suara
        $suara = Suara::with(['tps.kelurahan_desa.kecamatan.kabupaten_kota', 'suara_details', 'file_lampirans'])->findOrFail($id);
        if (!file_exists(storage_path('app/download/'))) {
            mkdir(storage_path('app/download/'), 0777, true);
        }
        // Lokasi penyimpanan sementara ZIP
        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            $zipFilePath = storage_path('app\download\\' . $this->formatFileName('file_c_hasil', $suara) . '.zip');
        } else {
            $zipFilePath = storage_path('app/download/' . $this->formatFileName('file_c_hasil', $suara) . '.zip');
        }

        // dd($zipFilePath,realpath($zipFilePath));
        $zip = new ZipArchive();
        if ($zip->open($zipFilePath, ZipArchive::CREATE | ZipArchive::OVERWRITE) === true) {


            // $kabupaten = $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama;
            // $kecamatan = $suara->tps->kelurahan_desa->kecamatan->nama;
            // $kelurahan = $suara->tps->kelurahan_desa->nama;
            // $tps = $suara->tps->nomor;
            // Loop file suara
            foreach ($suara->file_lampirans as $file_lampiran) {
                $filePath = $file_lampiran->file;
                if ($filePath && Storage::exists($filePath)) {

                    // Tambahkan file ke ZIP
                    $zip->addFile(Storage::path($filePath), $filePath);
                }
            }

            // Tutup ZIP
            $zip->close();


        } else {
            return response()->json(['error' => 'Failed to create ZIP file'], 500);
        }

        if (!file_exists($zipFilePath)) {
            return response()->json(['error' => 'Failed to create ZIP file : empty'], 500);
        }

        // Unduh file ZIP
        return response()->download($zipFilePath)->deleteFileAfterSend(true);

    }

    public function download(Request $request)
    {
        // Ambil data suara
        $datas = Suara::with(['tps.kelurahan_desa.kecamatan.kabupaten_kota', 'suara_details', 'file_lampirans']);
        if (auth()->user()->role == "koordinator-kecamatan") {
            $datas = $datas->whereHas('tps.kelurahan_desa', function ($w) {
                $w->where('kecamatan_id', auth()->user()->kecamatan_id);
            });
        }

        if (auth()->user()->role == "koordinator-kabupaten-kota") {
            $datas = $datas->whereHas('tps.kelurahan_desa.kecamatan', function ($w) {
                $w->where('kabupaten_kota_id', auth()->user()->kabupaten_kota_id);
            });
        }

        if (request()->kelurahan_desa_id) {
            $datas = $datas->whereHas('tps', function ($w) {
                $w->where('kelurahan_desa_id', request()->kelurahan_desa_id);
            });
        } else if (request()->kecamatan_id) {
            $datas = $datas->whereHas('tps', function ($w) {
                $w->whereHas('kelurahan_desa', function ($w) {
                    $w->where('kecamatan_id', request()->kecamatan_id);
                });
            });
        } else if (request()->kabupaten_kota_id) {
            $datas = $datas->whereHas('tps', function ($w) {
                $w->whereHas('kelurahan_desa', function ($w) {
                    $w->whereHas('kecamatan', function ($w) {
                        $w->where('kabupaten_kota_id', request()->kabupaten_kota_id);
                    });
                });
            });
        } else if (request()->provinsi_id) {
            $datas = $datas->whereHas('tps', function ($w) {
                $w->whereHas('kelurahan_desa', function ($w) {
                    $w->whereHas('kecamatan', function ($w) {
                        $w->whereHas('kabupaten_kota', function ($w) {
                            $w->where('provinsi_id', request()->provinsi_id);
                        });
                    });
                });
            });
        }

        if (request()->partai_id) {
            $datas = $datas->whereHas('multi_user', function ($w) {
                $w->where('partai_id', request()->partai_id);
            });
        }

        if (request()->tanggal_awal) {
            $datas = $datas->whereDate('suaras.created_at', '>=', request()->tanggal_awal);
        }

        if (request()->tanggal_akhir) {
            $datas = $datas->whereDate('suaras.created_at', '<=', request()->tanggal_akhir);
        }

        $suaras = $datas->get();
        if (!file_exists(storage_path('app/download/'))) {
            mkdir(storage_path('app/download/'), 0777, true);
        }
        // Lokasi penyimpanan sementara ZIP
        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            $zipFilePath = storage_path('app\download\\' . $suaras->count() . '_suara_file_c_hasil_' . date("YmdHis") . '.zip');
        } else {
            $zipFilePath = storage_path('app/download/' . $suaras->count() . '_suara_file_c_hasil_' . date("YmdHis") . '.zip');
        }
        // dd($zipFilePath,realpath($zipFilePath));
        $zip = new ZipArchive();
        if ($zip->open($zipFilePath, ZipArchive::CREATE | ZipArchive::OVERWRITE) === true) {

            foreach ($suaras as $suara) {
                // $kabupaten = $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama;
                // $kecamatan = $suara->tps->kelurahan_desa->kecamatan->nama;
                // $kelurahan = $suara->tps->kelurahan_desa->nama;
                // $tps = $suara->tps->nomor;
                // Loop file suara
                foreach ($suara->file_lampirans as $file_lampiran) {
                    $filePath = $file_lampiran->file;
                    if ($filePath && Storage::exists($filePath)) {

                        // Tambahkan file ke ZIP
                        $zip->addFile(Storage::path($filePath), $filePath);
                    }
                }

            }
            // Tutup ZIP
            $zip->close();


        } else {
            return response()->json(['error' => 'Failed to create ZIP file'], 500);
        }

        if (!file_exists($zipFilePath)) {
            return response()->json(['error' => 'Failed to create ZIP file : empty'], 500);
        }

        // Unduh file ZIP
        return response()->download($zipFilePath)->deleteFileAfterSend(true);
    }

    public function checkSudahDiinput(Request $request)
    {
        $suara = Suara::with('suara_details', 'file_lampirans')->where('tps_id', $request->tps_id)->first();
        return response()->json([
            'data'=>$suara
        ]);
    }

    public function checkKpu(Request $request){
        $response1 = Http::get('https://sirekappilkada-obj-data.kpu.go.id/wilayah/pilkada/pkwkp/64/'.$request->kabupaten_kota_id.'.json');
        $dataKecamatans = $response1->json();
        
        $kecamatan_id = null;
        foreach ($dataKecamatans as $data) {
            if($data['nama'] == $request->kecamatan_nama){
                $kecamatan_id = $data['kode'];
            }
        }

        $response2 = Http::get('https://sirekappilkada-obj-data.kpu.go.id/wilayah/pilkada/pkwkp/64/'.$request->kabupaten_kota_id.'/'.$kecamatan_id.'.json');
        $dataKelurahanDesas = $response2->json();
      
        $kelurahan_desa_id = null;
        foreach ($dataKelurahanDesas as $data) {
            if($data['nama'] == $request->kelurahan_desa_nama){
                $kelurahan_desa_id = $data['kode'];
            }
        }
        
        $response3 = Http::get('https://sirekappilkada-obj-data.kpu.go.id/pilkada/hhcw/pkwkp/64/'.$request->kabupaten_kota_id.'/'.$kecamatan_id.'/'.$kelurahan_desa_id.'/'.($kelurahan_desa_id.''.sprintf('%03d',str_replace("TPS ","",$request->tps_nomor))).'.json');
        return $response3->json();
    }
}
