<?php

namespace App\Http\Controllers\Saksi;

use App\Http\Controllers\Controller;
use App\Models\Calon;
use App\Models\Dpt;
use App\Models\Suara;
use App\Models\Tps;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LihatCalonController extends Controller
{
    public function index(){
        $user = Auth::user()->load(['tps','kelurahan_desa']);
        $calons = Calon::orderBy('nomor','ASC')->withSum([
            'suara_details'=>function($w){
                $w->whereHas('suara',function($ww){
                    $ww->where('tps_id',auth()->user()->tps_id)->whereHas('multi_user',function($w){
                        $w->where('user_id',auth()->user()->id);
                    });
                });
            }
        ],'jumlah_suara')->get();
        $suara = Suara::with(relations: 'suara_details')->where('tps_id',$user->tps_id)->first();
        $totalDpt = Dpt::where('tps_id',$user->tps_id)->count(); 
        $tps = Tps::with(['kelurahan_desa'=>function($w){
            $w->with(['users'=>function($wu){
                $wu->where('role','koordinator-kelurahan-desa');
            }]);
        }])->find($user->tps_id);
        return view('dashboard-saksi.lihat-calon.index',compact('calons','user','suara','totalDpt','tps'));
    }
}
