<?php

namespace App\Http\Controllers\Saksi;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Models\FileLampiran;
use App\Models\Suara;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Laravel\Facades\Image;

class InputLampiranController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $suara = Suara::with('tps.kelurahan_desa.kecamatan.kabupaten_kota.provinsi')->where('tps_id', $user->tps_id)->first();
        $file1 = FileLampiran::where('suara_id', @$suara->id)->where('nama', 'lembar-1')->first();
        $file2 = FileLampiran::where('suara_id', @$suara->id)->where('nama', 'lembar-2')->first();
        $file3 = FileLampiran::where('suara_id', @$suara->id)->where('nama', 'lembar-3')->first();
        return view('dashboard-saksi.input-lampiran.index', compact('file1', 'file2', 'file3', 'suara'));
    }

    private function cleanString($str)
    {
        return str_replace(" ", "-", trim(str_replace("'", " ", str_replace(".", " ", $str))));
    }

    private function formatFileName($prefix, $suara)
    {
        return $prefix . "_"
            . $this->cleanString($suara->tps->nomor) . "_"
            . $this->cleanString($suara->tps->kelurahan_desa->nama) . "_"
            . $this->cleanString($suara->tps->kelurahan_desa->kecamatan->nama) . "_"
            . $this->cleanString($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama) . "_"
            . $this->cleanString($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama);
    }

    public function save(Request $request)
    {   
        return redirect()->back()->with('warning','Belum waktunya pengambilan suara')->withInput($request->all());
        if(strtotime(date("Y-m-d H:i:s"))<strtotime("2024-11-27 13:45:00")){
            return redirect()->back()->with('warning','Belum waktunya pengambilan suara')->withInput($request->all());
        }
        $request->validate([
            'file_1' => 'nullable|file',
            'file_2' => 'nullable|file',
            'file_3' => 'nullable|file',
        ]);
        $user = Auth::user();
        $suara = Suara::with('tps.kelurahan_desa.kecamatan.kabupaten_kota.provinsi')->where('tps_id', $user->tps_id)->first();
        if (!$suara) {
            $suara = Suara::create([
                'user_id' => $user->id,
                'tps_id' => $user->tps_id,
                'tanggal' => date("Y-m-d"),
                'total_suara' => 0,
                'suara_tidak_sah' => 0,
                'suara_sah' => 0,
                'jumlah_dpt' => 0,
                'jumlah_hak_pilih' => 0,
                'jumlah_surat_suara_digunakan' => 0,
                'status' => 'approve',

            ]);
            $suara->multi_user()->attach([$user->id]);
        }
        if ($request->hasFile('file_1')) {
            $file = $request->file_1;
            $exte = strtolower($file->getClientOriginalExtension());
            if (strpos($exte, 'php') !== false) {
                return redirect()->back()->with('error', 'Format file 1 tidak sesuai');
            }
            $exte = strtolower(pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION));
            if (strpos($exte, 'php') !== false) {
                return redirect()->back()->with('error', 'Format file 1 tidak sesuai');
            }
            if (strpos(file_get_contents($file), '<?php') !== false) {
                return redirect()->back()->with('error', 'Yakin ini file 1 gambar?');
            }
            $lembar1 = FileLampiran::updateOrCreate([
                'suara_id' => $suara->id,
                'nama' => 'lembar-1'
            ], [
                'file' => $request->file('file_1')->storeAs($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                    $suara->tps->kelurahan_desa->nama . "/" .
                    $suara->tps->nomor, $this->formatFileName('lembar_1', $suara) . "." . $request->file('file_1')->extension())
            ]);
        }

        if ($request->hasFile('file_2')) {
            $file = $request->file_2;
            $exte = strtolower($file->getClientOriginalExtension());
            if (strpos($exte, 'php') !== false) {
                return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
            }
            $exte = strtolower(pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION));
            if (strpos($exte, 'php') !== false) {
                return redirect()->back()->with('error', 'Format file 2 tidak sesuai');
            }
            if (strpos(file_get_contents($file), '<?php') !== false) {
                return redirect()->back()->with('error', 'Yakin ini file 2 gambar?');
            }
            $lembar2 = FileLampiran::updateOrCreate([
                'suara_id' => $suara->id,
                'nama' => 'lembar-2'
            ], [
                'file' => $request->file('file_2')->storeAs($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                    $suara->tps->kelurahan_desa->nama . "/" .
                    $suara->tps->nomor, $this->formatFileName('lembar_2', $suara) . "." . $request->file('file_2')->extension())
            ]);
        }

        if ($request->hasFile('file_3')) {
            $file = $request->file_3;
            $exte = strtolower($file->getClientOriginalExtension());
            if (strpos($exte, 'php') !== false) {
                return redirect()->back()->with('error', 'Format file 3 tidak sesuai');
            }
            $exte = strtolower(pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION));
            if (strpos($exte, 'php') !== false) {
                return redirect()->back()->with('error', 'Format file 3 tidak sesuai');
            }
            if (strpos(file_get_contents($file), '<?php') !== false) {
                return redirect()->back()->with('error', 'Yakin ini file 3 gambar?');
            }
            $lembar3 = FileLampiran::updateOrCreate([
                'suara_id' => $suara->id,
                'nama' => 'lembar-3'
            ], [
                'file' => $request->file('file_3')->storeAs($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                    $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                    $suara->tps->kelurahan_desa->nama . "/" .
                    $suara->tps->nomor, $this->formatFileName('lembar_3', $suara) . "." . $request->file('file_3')->extension())
            ]);
        }

        Helper::addUserLog("Mengupload file lampiran", json_encode([
            @$lembar1,
            @$lembar2,
            @$lembar3
        ]));

        return redirect()->route('user-saksi.input-lampiran.index')->with('success', 'File berhasil disimpan');
    }

    public function getFileLampiran($id)
    {
        $user = Auth::user();
        $suara = Suara::with('tps.kelurahan_desa.kecamatan.kabupaten_kota.provinsi')->whereHas('multi_user', function ($w) use ($user) {
            $w->where('user_id', $user->id);
        })->where('tps_id', $user->tps_id)->first();
        if(!$suara){
            return abort(404);
        }
        $fileLampiran = FileLampiran::where('suara_id', $suara->id)->where('id', $id)->first();
        if(!$fileLampiran){
            return abort(404);
        }
        $path = $fileLampiran->file;

        if (Storage::exists($path)) {
            $mimeType = Storage::mimeType($path);
            $filename = basename($path);
            if (strpos($mimeType, 'php') !== false) {
                return response()->json([
                    'error'=>'Format file tidak sesuai'
                ]);
            }
            $exte = strtolower(pathinfo(storage_path("app/" . $path), PATHINFO_EXTENSION));
            if (strpos($exte, 'php') !== false) {
                return response()->json([
                    'error'=>'Format file tidak sesuai'
                ]);
            }
            if (strpos(file_get_contents(storage_path("app/" . $path)), '<?php') !== false) {
                return response()->json([
                    'error'=>'Yakin ini file gambar?'
                ]);
            }
            if (request()->size == "small") {
                $img = Image::read(storage_path("app/" . $path));
                // $img->resize(100, 100);
                $img->scaleDown(width: 150);

                return response($img->toJpeg(70), 200)
                    ->header('Content-Type', $mimeType)
                    ->header('Content-Disposition', 'attachment; filename=' . '"' . $filename . '"')
                    ->header("Connection", "Keep-Alive");
            }
            return response()->file(storage_path("app/" . $path), [
                'Content-Type' => $mimeType,
                'Content-Disposition' => 'attachment; filename=' . '"' . $filename . '"',
                "Connection" => "Keep-Alive",
            ]);
        } else {
            return abort(404);
        }

    }
}
