<?php

namespace App\Http\Controllers\Saksi;

use App\Http\Controllers\Controller;
use App\Models\Calon;
use App\Models\Suara;
use App\Models\Tps;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{
    public function index()
    {   
        $jumlahCalon = Calon::count();
        $user = Auth::user()->load(['tps','kelurahan_desa']);
        $totalSuara = Suara::where('tps_id',$user->tps_id)->whereHas('multi_user',function($w)use($user){
            $w->where('user_id',$user->id);
        })->sum('total_suara');
        $tps = Tps::with(['kelurahan_desa'=>function($w){
            $w->with(['users'=>function($wu){
                $wu->where('role','koordinator-kelurahan-desa');
            }]);
        }])->find($user->tps_id);
        $user_koordes = implode(",", User::where('role', 'koordinator-kelurahan-desa')->where('kelurahan_desa_id', $tps->kelurahan_desa_id)->whereHas('multi_tps', function ($w) use ($user) {
            $w->where('tps_id', $user->tps_id);
        })->get()->pluck('nama')->toArray());

        $user_koorcam = implode(",", User::where('role', 'koordinator-kecamatan')->where('kecamatan_id', $tps->kelurahan_desa->kecamatan_id)->get()->pluck('nama')->toArray());
        return view('dashboard-saksi.home',compact('jumlahCalon','totalSuara','tps','user_koordes','user_koorcam'));
    }
}
